/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util.localization;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class LocalizeHelper {
    File sourceRoot;
    File targetRoot;
    String targetLang;
    List modifiedFiles = new ArrayList();

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println(LocalizeHelper.class.getName() + " <source-dir> <target-dir> <target-language>");
            return;
        }
        LocalizeHelper helper = new LocalizeHelper(args[0], args[1], args[2]);
        helper.run();
    }

    public LocalizeHelper(String sourceName, String targetName, String targetLang) {
        this.sourceRoot = new File(sourceName);
        this.targetRoot = new File(targetName);
        this.targetLang = "_" + targetLang;
    }

    private void run() {
        System.out.println("<source-dir> " + this.sourceRoot);
        System.out.println("<target-dir> " + this.targetRoot);
        System.out.println("<target-lang> " + this.targetLang);
        Hashtable sourceProperties = new Hashtable();
        Hashtable targetProperties = new Hashtable();
        this.findProperties(this.sourceRoot, sourceProperties, this.sourceRoot.getAbsolutePath().length(), "");
        this.findProperties(this.targetRoot, targetProperties, this.targetRoot.getAbsolutePath().length(), this.targetLang);
        try {
            this.sync(sourceProperties, targetProperties);
            if (this.modifiedFiles.size() > 0) {
                System.out.println("Modified files:");
                for (Object modifiedFile : this.modifiedFiles) {
                    System.out.print("  ");
                    System.out.println(modifiedFile);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void findProperties(File dir, Map propertyFiles, int ignorePathPrefixLength, String langPostfix) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.getName().equalsIgnoreCase("messages" + langPostfix + ".properties")) {
                String name = file.getAbsolutePath().substring(ignorePathPrefixLength);
                name = name.substring(0, name.lastIndexOf(langPostfix + ".properties"));
                propertyFiles.put(name, file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.findProperties(file, propertyFiles, ignorePathPrefixLength, langPostfix);
        }
    }

    private void sync(Hashtable source, Hashtable target) throws IOException {
        Enumeration sourceNames = source.keys();
        while (sourceNames.hasMoreElements()) {
            String key;
            String name = (String)sourceNames.nextElement();
            File targetFile = (File)target.get(name);
            if (targetFile == null) {
                File sourceFile = (File)source.get(name);
                String newName = this.targetRoot.getAbsolutePath() + name + this.targetLang + ".properties";
                targetFile = new File(newName);
                this.createFile(targetFile);
                this.modifiedFiles.add(targetFile);
                FileWriter writer = new FileWriter(targetFile);
                FileReader reader = new FileReader(sourceFile);
                int c = reader.read();
                while (c != -1) {
                    writer.write(c);
                    c = reader.read();
                }
                reader.close();
                writer.close();
                continue;
            }
            SortedProperties sourceProps = new SortedProperties();
            File srcFile = (File)source.get(name);
            sourceProps.load(new FileInputStream(srcFile));
            SortedProperties targetProps = new SortedProperties();
            targetProps.load(new FileInputStream(targetFile));
            Set srcKeys = sourceProps.keySet();
            boolean modified = false;
            for (Object srcKey : srcKeys) {
                key = (String)srcKey;
                if (targetProps.getProperty(key) != null) continue;
                targetProps.setProperty(key, ">TRANSLATE_ME<" + sourceProps.getProperty(key));
                modified = true;
            }
            Set targetKeys = targetProps.keySet();
            Iterator it = targetKeys.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                if (sourceProps.get(key) != null) continue;
                it.remove();
                modified = true;
            }
            if (!modified) continue;
            this.modifiedFiles.add(targetFile);
            SortedProperties newTargetProps = new SortedProperties();
            Set srcKeySet = sourceProps.keySet();
            for (Object element : srcKeySet) {
                String key2 = (String)element;
                String property = targetProps.getProperty(key2);
                newTargetProps.setProperty(key2, property);
            }
            FileOutputStream out = new FileOutputStream(targetFile);
            newTargetProps.store(out, "File modified by LocalizationHelper");
            out.close();
        }
    }

    private void createFile(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
    }

    private static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        LinkedHashMap content = new LinkedHashMap();

        private SortedProperties() {
        }

        @Override
        public synchronized String getProperty(String arg0) {
            return (String)this.content.get(arg0);
        }

        @Override
        public synchronized Object setProperty(String arg0, String arg1) {
            return this.content.put(arg0, arg1);
        }

        @Override
        public synchronized void load(InputStream is) throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "8859_1"));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] props;
                if (line.indexOf("=") <= 0 || (props = StringUtils.split((String)line, (String)"=", (int)2)).length != 2) continue;
                this.content.put(props[0], props[1]);
            }
        }

        @Override
        public synchronized void store(OutputStream os, String comments) throws IOException {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, "8859_1"));
            if (comments != null) {
                this.writeln(bw, "#" + comments);
            }
            this.writeln(bw, "#" + new Date().toString());
            for (Object element : this.content.keySet()) {
                String key = (String)element;
                bw.write(key);
                bw.write("=");
                bw.write((String)this.content.get(key));
                bw.newLine();
            }
            bw.flush();
        }

        private void writeln(BufferedWriter bw, String s) throws IOException {
            bw.write(s);
            bw.newLine();
        }

        @Override
        public Set keySet() {
            return this.content.keySet();
        }

        @Override
        public synchronized void clear() {
            this.content.clear();
        }

        @Override
        public synchronized boolean contains(Object arg0) {
            return this.content.containsValue(arg0);
        }

        @Override
        public synchronized boolean containsKey(Object arg0) {
            return this.content.containsKey(arg0);
        }

        @Override
        public boolean containsValue(Object arg0) {
            return this.content.containsValue(arg0);
        }

        @Override
        public Set entrySet() {
            return this.content.entrySet();
        }

        @Override
        public synchronized boolean equals(Object arg0) {
            return this.content.equals(arg0);
        }

        @Override
        public synchronized Object get(Object arg0) {
            return this.content.get(arg0);
        }

        @Override
        public synchronized int hashCode() {
            return this.content.hashCode();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.content.isEmpty();
        }

        @Override
        public synchronized Object put(Object arg0, Object arg1) {
            return this.content.put(arg0, arg1);
        }

        @Override
        public synchronized void putAll(Map arg0) {
            this.content.putAll(arg0);
        }

        @Override
        public synchronized Object remove(Object arg0) {
            return this.content.remove(arg0);
        }

        @Override
        public synchronized int size() {
            return this.content.size();
        }

        @Override
        public synchronized String toString() {
            return this.content.toString();
        }

        @Override
        public Collection values() {
            return this.content.values();
        }

        @Override
        public synchronized Object clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void rehash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized Enumeration keys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized Enumeration elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized String getProperty(String arg0, String arg1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void list(PrintStream arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void list(PrintWriter arg0) {
            throw new UnsupportedOperationException();
        }

        public Enumeration propertyNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void save(OutputStream arg0, String arg1) {
            throw new UnsupportedOperationException();
        }
    }
}

