/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;

public class MethodAccess {
    private final Class<?> clazz;
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private Optional<Method> method;
    private RuntimeException exception;

    private MethodAccess(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        this.clazz = clazz;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        try {
            this.method = Optional.of(this.getMethod());
        }
        catch (RuntimeException e) {
            this.exception = e;
            this.method = Optional.empty();
        }
    }

    public static final MethodAccess of(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (IpsStringUtils.isBlank((String)Objects.requireNonNull(methodName, "methodName must not be null"))) {
            throw new IllegalArgumentException("methodName must not be empty");
        }
        for (Class<?> parameterType : parameterTypes) {
            Objects.requireNonNull(parameterType, "parameterType must not be null");
        }
        return new MethodAccess(clazz, methodName, parameterTypes);
    }

    private Method getMethod() {
        return Arrays.stream(this.clazz.getMethods()).filter(m -> m.getName().equals(this.methodName)).filter(m -> m.getParameterCount() == this.parameterTypes.length).filter(m -> {
            Class<?>[] actualParameterTypes = m.getParameterTypes();
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (this.parameterTypes[i].isAssignableFrom(actualParameterTypes[i])) continue;
                return false;
            }
            return true;
        }).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find the method " + this.methodName + "(" + Arrays.stream(this.parameterTypes).map(Object::toString).collect(Collectors.joining()) + ") on the adapted class " + this.clazz));
    }

    public <T> T invoke(String methodDescription, Object object, Object ... args) {
        try {
            return (T)this.method.orElseThrow(() -> this.exception).invoke(object, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | IllegalStateException | NullPointerException | InvocationTargetException e) {
            throw new MethodAccessException("Unable to invoke the method " + methodDescription + " " + this.methodName + " on the class: " + this.clazz, e);
        }
    }

    public <T> T invokeStatic(String methodDescription, Object ... args) {
        return this.invoke(methodDescription, null, args);
    }

    public boolean exists() {
        return this.method.isPresent();
    }

    public String toString() {
        return "MethodAccess [" + this.clazz + "." + this.methodName + (String)(this.parameterTypes != null ? "(" + Arrays.toString(this.parameterTypes) + ")" : "()");
    }

    public Check check(MessageList messageList, String msgCodePrefix) {
        Objects.requireNonNull(messageList, "messageList must not be null");
        Objects.requireNonNull(msgCodePrefix, "msgCodePrefix must not be null");
        return new Check(messageList, msgCodePrefix);
    }

    public static class MethodAccessException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MethodAccessException(String message) {
            super(message);
        }

        public MethodAccessException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public class Check {
        public static final String MSG_CODE_SUFFIX_DOES_NOT_EXIST = "_NOT_FOUND";
        public static final String MSG_CODE_SUFFIX_NOT_STATIC = "_NOT_STATIC";
        public static final String MSG_CODE_SUFFIX_STATIC = "_STATIC";
        public static final String MSG_CODE_SUFFIX_INCOMPATIBLE_RETURN_TYPE = "_INCOMPATIBLE_RETURN_TYPE";
        private final MessageList messageList;
        private final String msgCodePrefix;

        private Check(MessageList messageList, String msgCodePrefix) {
            this.messageList = messageList;
            this.msgCodePrefix = msgCodePrefix;
        }

        public Check exists() {
            if (!MethodAccess.this.exists()) {
                String text = MessageFormat.format("The Java class {0} hasn''t got a method {1}", MethodAccess.this.clazz, MethodAccess.this.methodName);
                if (this.messageList.getMessagesFor(MethodAccess.this.clazz, MethodAccess.this.methodName).getMessagesByCode(this.msgCodePrefix + MSG_CODE_SUFFIX_DOES_NOT_EXIST).isEmpty()) {
                    this.messageList.add(Message.error((String)text).code(this.msgCodePrefix + MSG_CODE_SUFFIX_DOES_NOT_EXIST).invalidObjectWithProperties(MethodAccess.this.clazz, new String[]{MethodAccess.this.methodName}).create());
                }
            }
            return this;
        }

        public Check isStatic() {
            MethodAccess.this.method.ifPresentOrElse(m -> {
                if (!Modifier.isStatic(m.getModifiers())) {
                    this.messageList.add(Message.error((String)("The method " + m + " is not static.")).code(this.msgCodePrefix + MSG_CODE_SUFFIX_NOT_STATIC).invalidObjectWithProperties(MethodAccess.this.clazz, new String[]{MethodAccess.this.methodName}).create());
                }
            }, this::exists);
            return this;
        }

        public Check isNotStatic() {
            MethodAccess.this.method.ifPresentOrElse(m -> {
                if (Modifier.isStatic(m.getModifiers())) {
                    this.messageList.add(Message.error((String)("The method " + m + " is static.")).code(this.msgCodePrefix + MSG_CODE_SUFFIX_STATIC).invalidObjectWithProperties(MethodAccess.this.clazz, new String[]{MethodAccess.this.methodName}).create());
                }
            }, this::exists);
            return this;
        }

        public Check returnTypeIsCompatible(Class<?> ... expectedReturnTypes) {
            MethodAccess.this.method.ifPresent(m -> {
                if (!this.isCompatible(m.getReturnType(), expectedReturnTypes)) {
                    this.messageList.add(Message.error((String)("The method " + m + " does not return a " + Arrays.stream(expectedReturnTypes).map(Class::getSimpleName).collect(Collectors.joining(" or ")))).code(this.msgCodePrefix + MSG_CODE_SUFFIX_INCOMPATIBLE_RETURN_TYPE).invalidObjectWithProperties(MethodAccess.this.clazz, new String[]{MethodAccess.this.methodName}).create());
                }
            });
            return this;
        }

        private boolean isCompatible(Class<?> actualType, Class<?> ... expectedTypes) {
            Class wrappedActualType = ClassUtils.primitiveToWrapper(actualType);
            return Arrays.stream(expectedTypes).map(ClassUtils::primitiveToWrapper).anyMatch(cl -> cl.isAssignableFrom(wrappedActualType));
        }
    }
}

