/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util;

import java.util.Collection;
import org.faktorips.annotation.UtilityClass;
import org.w3c.dom.Node;

@UtilityClass
public class ArgumentCheck {
    private ArgumentCheck() {
    }

    public static final void notNull(Object arg) {
        if (arg == null) {
            throw new NullPointerException();
        }
    }

    public static final void notNull(Object[] arg) {
        ArgumentCheck.notNull((Object)arg);
        for (Object element : arg) {
            ArgumentCheck.notNull(element);
        }
    }

    public static final void notNull(Object[] arg, Object context) {
        ArgumentCheck.notNull((Object)arg);
        for (Object element : arg) {
            ArgumentCheck.notNull(element, context);
        }
    }

    public static final void notNull(Object arg, Object context) {
        if (arg == null) {
            throw new NullPointerException("" + context);
        }
    }

    public static final void isTrue(boolean arg) {
        if (!arg) {
            throw new IllegalArgumentException();
        }
    }

    public static final void isTrue(boolean arg, Object context) {
        if (!arg) {
            throw new IllegalArgumentException(context.toString());
        }
    }

    public static final void equals(Object arg1, Object arg2) {
        if (!arg1.equals(arg2)) {
            throw new IllegalArgumentException();
        }
    }

    public static final void equals(Object arg1, Object arg2, Object context) {
        if (!arg1.equals(arg2)) {
            throw new IllegalArgumentException(context.toString());
        }
    }

    public static final void isInstanceOf(Object arg, Class<?> clazz) {
        if (!clazz.isAssignableFrom(arg.getClass())) {
            throw new IllegalArgumentException();
        }
    }

    public static final void isInstanceOf(Object arg, Class<?> clazz, Object context) {
        if (!clazz.isAssignableFrom(arg.getClass())) {
            throw new IllegalArgumentException(context.toString());
        }
    }

    public static final void length(Object[] arg, int length) {
        if (arg.length != length) {
            throw new IllegalArgumentException();
        }
    }

    public static final void atLeast(Collection<?> c, int size) {
        if (c.size() < size) {
            throw new IllegalArgumentException();
        }
    }

    public static final void length(Object[] a, int length, Object context) {
        if (a.length != length) {
            throw new IllegalArgumentException(context.toString());
        }
    }

    public static final void isSubclassOf(Class<?> subclass, Class<?> superclass) {
        if (!superclass.isAssignableFrom(subclass)) {
            throw new IllegalArgumentException(subclass + " is not a subclass of " + superclass);
        }
    }

    public static final void nodeName(Node node, String name) {
        if (!node.getNodeName().equals(name)) {
            throw new IllegalArgumentException("Node has name " + node.getNodeName() + ", expected " + name + ".");
        }
    }
}

