/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class ListComparator<T>
implements Comparator<List<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> elementComparator;

    public ListComparator(Comparator<T> elementComparator) {
        this.elementComparator = elementComparator;
    }

    public static <T> ListComparator<T> listComparator(Comparator<T> elementComparator) {
        return new ListComparator<T>(elementComparator);
    }

    @Override
    public int compare(List<T> o1, List<T> o2) {
        int compareSize = Integer.compare(o1.size(), o2.size());
        if (compareSize != 0) {
            return compareSize;
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int compareValueAtIndex = this.compareValueAtIndex(o1, o2, i);
            if (compareValueAtIndex == 0) continue;
            return compareValueAtIndex;
        }
        return 0;
    }

    private int compareValueAtIndex(List<T> o1, List<T> o2, int i) {
        T o1Value = o1.get(i);
        T o2Value = o2.get(i);
        return this.elementComparator.compare(o1Value, o2Value);
    }
}

