/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.faktorips.util.MultiMap;

public class SortedMultiMap<K, V>
extends MultiMap<K, V> {
    private static final long serialVersionUID = 1L;

    public SortedMultiMap() {
        super(new TreeMap(), new SortedSetFactory());
    }

    public SortedMultiMap(Comparator<? super K> keyComparator, Comparator<? super V> valueComparator) {
        super(Collections.synchronizedSortedMap(new TreeMap(keyComparator)), new SortedSetFactory<V>(valueComparator));
    }

    public static class SortedSetFactory<V>
    implements MultiMap.CollectionFactory<V> {
        private static final long serialVersionUID = 2534395916683559784L;
        private Comparator<? super V> valueComparator;

        public SortedSetFactory() {
            this.valueComparator = null;
        }

        public SortedSetFactory(Comparator<? super V> valueComparator) {
            this.valueComparator = valueComparator;
        }

        @Override
        public Collection<V> createCollection() {
            return new TreeSet<V>(this.valueComparator);
        }
    }
}

