/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.faktorips.annotation.UtilityClass;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.StreamUtil;

@UtilityClass
public class StringUtil {
    public static final String BLANK = " ";
    public static final String CAMEL_CASE_SEPERATORS = "[-_., ]";
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    private static final String FORMAT_CARDINALITY = "[%d..%s]";
    private static final String FORMAT_CARDINALITY_WITH_DEFAULT = "[%d..%s, %d]";

    private StringUtil() {
    }

    public static final String readFromInputStream(InputStream is, Charset charset) throws IOException {
        return StringUtil.readFromInputStream(is, charset.name());
    }

    public static final String readFromInputStream(InputStream is, String charsetName) throws IOException {
        ByteArrayOutputStream buffer;
        try (ByteArrayOutputStream byteArrayOutputStream = buffer = StreamUtil.toByteArrayOutputStream(is);){
            String string = buffer.toString(charsetName);
            return string;
        }
    }

    public static final String unqualifiedName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(".");
        if (index == -1) {
            return qualifiedName;
        }
        return qualifiedName.substring(index + 1);
    }

    public static final String getPackageName(String qualifiedClassName) {
        int index = qualifiedClassName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return qualifiedClassName.substring(0, index);
    }

    public static String getFilenameWithoutExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return fileName.substring(index + 1, fileName.length());
    }

    public static InputStream getInputStreamForString(String data, String charset) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(data.getBytes(charset));
    }

    public static String toCamelCase(String text, boolean firstUp) {
        if (IpsStringUtils.isBlank((String)text)) {
            return "";
        }
        String[] words = text.split(CAMEL_CASE_SEPERATORS);
        StringBuilder result = new StringBuilder();
        boolean firstUp2 = firstUp;
        for (String word : words) {
            char firstChar = word.charAt(0);
            firstChar = firstUp2 ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar);
            result.append(firstChar).append(word.substring(1).toLowerCase());
            firstUp2 = true;
        }
        return result.toString();
    }

    public static String camelCaseToUnderscore(String text) {
        return StringUtil.camelCaseToUnderscore(text, false);
    }

    public static String camelCaseToUnderscore(String text, boolean splitUppercaseSequences) {
        if (text == null || "".equals(text)) {
            return "";
        }
        String regex = splitUppercaseSequences ? "([A-Z])" : "([^A-Z])([A-Z])";
        String result = text.replaceAll(regex, splitUppercaseSequences ? "_$1" : "$1_$2");
        if ((result = result.replaceAll("[-_., ][-_., ]*", "_")).charAt(0) == '_') {
            result = result.substring(1, result.length());
        }
        if (result.charAt(result.length() - 1) == '_') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String getRangeString(int minValue, int maxValue) {
        return String.format(FORMAT_CARDINALITY, minValue, StringUtil.formatMax(maxValue));
    }

    public static String getRangeString(int minValue, int maxValue, int defaultValue) {
        return String.format(FORMAT_CARDINALITY_WITH_DEFAULT, minValue, StringUtil.formatMax(maxValue), defaultValue);
    }

    private static String formatMax(int maxValue) {
        return maxValue == Integer.MAX_VALUE ? "*" : String.valueOf(maxValue);
    }

    public static boolean containsWhitespace(String string) {
        return string != null && string.codePoints().anyMatch(Character::isWhitespace);
    }
}

