/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.faktorips.runtime.MessageList;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class MessageListCodeMatcher
extends TypeSafeMatcher<MessageList> {
    @CheckForNull
    private final String messageCode;
    private boolean expectMessage;

    public MessageListCodeMatcher(@CheckForNull String messageCode) {
        this.messageCode = messageCode;
        this.expectMessage = true;
    }

    public MessageListCodeMatcher(@CheckForNull String messageCode, boolean expectMessage) {
        this.messageCode = messageCode;
        this.expectMessage = expectMessage;
    }

    public void describeTo(Description description) {
        if (this.expectMessage) {
            description.appendText("a messageList containing messages with code: " + this.messageCode);
        } else {
            description.appendText("a messageList without message code: " + this.messageCode);
        }
    }

    public boolean matchesSafely(MessageList list) {
        return list.getMessageByCode(this.messageCode) != null == this.expectMessage;
    }
}

