/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/

package org.faktorips.productdataservice;

import java.io.Serializable;
import java.util.Arrays;

/**
 * This data type combines XML content and time stamp. It is used by the {@link IProductDataService}
 * to provide XML content tagged with the time of the loaded table of content.
 * 
 * @author dirmeier
 */
public final class XmlTimestampData implements Serializable {

    private static final long serialVersionUID = -8884371376708389871L;

    /**
     * The XML data.
     */
    private final byte[] xmlData;

    /**
     * The version of the XML data.
     */
    private final String version;

    /**
     * Creating the data object
     * 
     * @param xmlData The XML content
     * @param version The time stamp of the loaded content
     */
    public XmlTimestampData(final byte[] xmlData, final String version) {
        this.xmlData = xmlData == null ? null : xmlData.clone();
        this.version = version;
    }

    public byte[] getXmlData() {
        return xmlData == null ? null : xmlData.clone();
    }

    public String getVersion() {
        return version;
    }

    @Override
    public String toString() {
        return "XmlTimestampData [version=" + getVersion() + ", xmlData=" + Arrays.toString(xmlData) + "]";
    }

}
