/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/

package org.faktorips.productdataservice;

import javax.ejb.Remote;

/**
 * The repote interface for the product data service. The interface is implemented by a EJB 3.0
 * stateless session bean.
 * <p>
 * This service provides the xml content of product data and the version of the actually loaded
 * data.
 * 
 * @author dirmeier
 */
@Remote
public interface IProductDataService {

    /**
     * Getting the modification time stamp or version of the table of contents actually loaded by
     * the product data service
     * 
     */
    public String getProductDataVersion();

    /**
     * Getting the content and time stamp for the table of content
     * 
     */
    public XmlTimestampData getTocData();

    /**
     * Getting the content and time stamp for the product component identified by the ips object id
     * 
     */
    public XmlTimestampData getProductCmptData(String ipsObjectId);

    /**
     * Getting the content and time stamp for the test case identified by its qualified name
     * 
     */
    public XmlTimestampData getTestCaseData(String qName);

    /**
     * Getting the content and times stamp for the table content identified by its qualified name
     */
    public XmlTimestampData getTableContent(String qName);

    /**
     * Getting the content and version for the enum content identified by the class name
     */
    public XmlTimestampData getEnumContent(String className);

    /**
     * Getting the content and times stamp for the content identified by its qualified name
     */
    public XmlTimestampData getTocEntryData(Class<?> type, String qName);

}
