/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider.ejbclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.faktorips.productdataservice.IProductDataService;
import org.faktorips.productdataservice.XmlTimestampData;
import org.faktorips.runtime.IVersionChecker;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.ReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.productdataprovider.AbstractProductDataProvider;
import org.faktorips.runtime.productdataprovider.DataModifiedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EjbProductDataProvider
extends AbstractProductDataProvider {
    public static final String EJB_EXCEPTION_MESSAGE = "Exception while accessing product data service, while getting ";
    public static final String EJB_EXCEPTION_MESSAGE_CAUSED_BY = "Exception caused by ";
    private static IVersionChecker versionChecker = new IVersionChecker(){

        public boolean isCompatibleVersion(String oldVersion, String newVersion) {
            return oldVersion.equals(newVersion);
        }
    };
    private final IProductDataService productDataService;
    private final ReadonlyTableOfContents toc;
    private final String version;

    EjbProductDataProvider(String beanName, InitialContext initialContext) {
        super(versionChecker);
        try {
            this.productDataService = (IProductDataService)initialContext.lookup(beanName);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.toc = this.loadToc();
        this.version = this.getBaseVersion();
    }

    public EjbProductDataProvider(IProductDataService productDataService) {
        super(versionChecker);
        if (productDataService == null) {
            throw new NullPointerException("Product data service must not be null");
        }
        this.productDataService = productDataService;
        this.toc = this.loadToc();
        this.version = this.getBaseVersion();
    }

    private ReadonlyTableOfContents loadToc() {
        XmlTimestampData timestampData = this.productDataService.getTocData();
        try {
            Document doc = this.getDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(timestampData.getXmlData())));
            Element tocElement = doc.getDocumentElement();
            ReadonlyTableOfContents readOnlyToc = new ReadonlyTableOfContents();
            readOnlyToc.initFromXml(tocElement);
            return readOnlyToc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public InputStream getEnumContentAsStream(EnumContentTocEntry tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData;
        try {
            timestampData = this.productDataService.getEnumContent(tocEntry.getImplementationClassName());
        }
        catch (EJBException e) {
            throw this.createEjbException(tocEntry.getIpsObjectQualifiedName(), e);
        }
        this.throwExceptionIfExpired(tocEntry.getImplementationClassName(), timestampData.getVersion());
        return new ByteArrayInputStream(timestampData.getXmlData());
    }

    public Element getProductCmptData(ProductCmptTocEntry tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData;
        try {
            timestampData = this.productDataService.getProductCmptData(tocEntry.getIpsObjectId());
        }
        catch (EJBException e) {
            throw this.createEjbException(tocEntry.getIpsObjectQualifiedName(), e);
        }
        this.throwExceptionIfExpired(tocEntry.getIpsObjectId(), timestampData.getVersion());
        try {
            Document doc = this.getDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(timestampData.getXmlData())));
            return doc.getDocumentElement();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public Element getProductCmptGenerationData(GenerationTocEntry tocEntry) throws DataModifiedException {
        Element docElement = this.getProductCmptData(tocEntry.getParent());
        NodeList nl = docElement.getChildNodes();
        DateTime validFrom = tocEntry.getValidFrom();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element genElement;
            DateTime generationValidFrom;
            if (!"Generation".equals(nl.item(i).getNodeName()) || !validFrom.equals((Object)(generationValidFrom = DateTime.parseIso((String)(genElement = (Element)nl.item(i)).getAttribute("validFrom"))))) continue;
            return genElement;
        }
        throw new RuntimeException("Can't find the generation for the toc entry " + tocEntry);
    }

    public InputStream getTableContentAsStream(TableContentTocEntry tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData;
        try {
            timestampData = this.productDataService.getTableContent(tocEntry.getIpsObjectQualifiedName());
        }
        catch (EJBException e) {
            throw this.createEjbException(tocEntry.getIpsObjectQualifiedName(), e);
        }
        this.throwExceptionIfExpired(tocEntry.getIpsObjectQualifiedName(), timestampData.getVersion());
        return new ByteArrayInputStream(timestampData.getXmlData());
    }

    public Element getTestcaseElement(TestCaseTocEntry tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData;
        try {
            timestampData = this.productDataService.getTestCaseData(tocEntry.getIpsObjectQualifiedName());
        }
        catch (EJBException e) {
            throw this.createEjbException(tocEntry.getIpsObjectQualifiedName(), e);
        }
        this.throwExceptionIfExpired(tocEntry.getIpsObjectId(), timestampData.getVersion());
        try {
            Document doc = this.getDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(timestampData.getXmlData())));
            return doc.getDocumentElement();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized IReadonlyTableOfContents getToc() {
        return this.toc;
    }

    public boolean isCompatibleToBaseVersion() {
        try {
            return super.isCompatibleToBaseVersion();
        }
        catch (EJBException exception) {
            return false;
        }
    }

    public String getBaseVersion() {
        return this.productDataService.getProductDataVersion();
    }

    private void throwExceptionIfExpired(String ipsObject, String version) throws DataModifiedException {
        if (!this.getVersionChecker().isCompatibleVersion(this.getVersion(), version)) {
            DataModifiedException e = new DataModifiedException("Data has changed: " + ipsObject, this.version, version);
            throw e;
        }
    }

    private DataModifiedException createEjbException(String objectName, EJBException e) {
        String causedByExceptionMsg = this.getEJBExceptionCauseMessage(e);
        DataModifiedException dataModifiedException = new DataModifiedException(EJB_EXCEPTION_MESSAGE_CAUSED_BY + causedByExceptionMsg + " ," + objectName, this.version, "<unknown>");
        Exception causedByException = e.getCausedByException();
        if (causedByException != null) {
            dataModifiedException.initCause((Throwable)causedByException);
        } else {
            dataModifiedException.initCause((Throwable)e);
        }
        return dataModifiedException;
    }

    private String getEJBExceptionCauseMessage(EJBException e) {
        Exception causedByException = e.getCausedByException();
        if (causedByException != null) {
            return causedByException.getMessage();
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            return cause.getMessage();
        }
        return "<unknown>";
    }

    public <T> Element getTocEntryData(CustomTocEntryObject<T> tocEntry) throws DataModifiedException {
        XmlTimestampData timestampData;
        try {
            timestampData = this.productDataService.getTocEntryData(tocEntry.getRuntimeObjectClass(), tocEntry.getIpsObjectQualifiedName());
        }
        catch (EJBException e) {
            throw this.createEjbException(tocEntry.getIpsObjectQualifiedName(), e);
        }
        this.throwExceptionIfExpired(tocEntry.getIpsObjectId(), timestampData.getVersion());
        try {
            Document doc = this.getDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(timestampData.getXmlData())));
            return doc.getDocumentElement();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

