/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/

package org.faktorips.runtime.productdataprovider.ejbclient;

import javax.naming.InitialContext;

import org.faktorips.runtime.productdataprovider.IProductDataProvider;
import org.faktorips.runtime.productdataprovider.IProductDataProviderFactory;

public class EjbProductDataProviderFactory implements IProductDataProviderFactory {

    private final String beanName;
    private final InitialContext initalContext;

    public EjbProductDataProviderFactory(String beanName, InitialContext initalContext) {
        this.beanName = beanName;
        this.initalContext = initalContext;
    }

    @Override
    public IProductDataProvider newInstance() {
        return new EjbProductDataProvider(beanName, initalContext);
    }

}
