/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.saxon;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Version {
    private static final String VER_PROP = "/org/expath/pkg/saxon/tools/version.properties";
    private static Version INSTANCE = null;
    private String myVersion;
    private String myRevision;

    public static void main(String[] args) {
        Version v = Version.instance();
        System.err.println("EXPath Packaging System standard on-disk repository, support for Saxon.");
        System.err.println("Version: " + v.getVersion() + " (revision #" + v.getRevision() + ")");
    }

    protected Version() {
        InputStream rsrc = Version.class.getResourceAsStream(VER_PROP);
        if (rsrc == null) {
            throw new IllegalStateException("Version properties file does not exist: /org/expath/pkg/saxon/tools/version.properties");
        }
        Properties props = new Properties();
        try {
            props.load(rsrc);
            rsrc.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error reading the version properties: /org/expath/pkg/saxon/tools/version.properties", ex);
        }
        this.myVersion = props.getProperty("org.expath.pkg.saxon.version");
        this.myRevision = props.getProperty("org.expath.pkg.saxon.revision");
    }

    public static synchronized Version instance() {
        if (INSTANCE == null) {
            INSTANCE = new Version();
        }
        return INSTANCE;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getRevision() {
        return this.myRevision;
    }
}

