/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.saxon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.saxon.SaxonRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkgURIResolver
implements URIResolver {
    private final Map<String, String> myOverrides;
    private final SaxonRepository myRepo;
    private final URIResolver myParent;
    private final URISpace mySpace;
    private static final Logger LOG = LoggerFactory.getLogger(PkgURIResolver.class);

    public PkgURIResolver(Map<String, String> overrides, SaxonRepository repo, URIResolver parent, URISpace space) throws PackageException {
        this.myOverrides = overrides;
        this.myRepo = repo;
        this.myParent = parent;
        this.mySpace = space;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        LOG.debug("resolve: {} with base: {}", (Object)href, (Object)base);
        String override = this.myOverrides.get(href);
        if (override != null) {
            StreamSource s;
            File f = new File(override);
            try {
                s = new StreamSource(new FileInputStream(f));
            }
            catch (FileNotFoundException ex) {
                throw new TransformerException("Error resolving the URI", ex);
            }
            s.setSystemId(f.toURI().toString());
            return s;
        }
        try {
            Source s = this.myRepo.resolve(href, this.mySpace);
            if (s != null) {
                return s;
            }
        }
        catch (PackageException ex) {
            throw new TransformerException("Error resolving the URI", ex);
        }
        return this.myParent.resolve(href, base);
    }
}

