/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.saxon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.trans.XPathException;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.saxon.SaxonRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkgModuleResolver
implements ModuleURIResolver {
    private final Map<String, String> myOverrides;
    private final SaxonRepository myRepo;
    private final Repository myParent;
    private static final Logger LOG = LoggerFactory.getLogger(PkgModuleResolver.class);

    public PkgModuleResolver(Map<String, String> overrides, SaxonRepository repo, Repository parent) throws PackageException {
        this.myOverrides = overrides;
        this.myRepo = repo;
        this.myParent = parent;
    }

    public StreamSource[] resolve(String module_uri, String base_uri, String[] locations) throws XPathException {
        LOG.debug("resolve: {} with base: {}", (Object)module_uri, (Object)base_uri);
        for (String l : locations) {
            LOG.debug("  location: {}", (Object)l);
        }
        try {
            String href = this.myOverrides.get(module_uri);
            if (href != null) {
                FileInputStream in;
                File f = new File(href);
                try {
                    in = new FileInputStream(f);
                }
                catch (FileNotFoundException ex) {
                    throw new PackageException("Error opening file", (Throwable)ex);
                }
                StreamSource[] source = new StreamSource[]{new StreamSource(in)};
                source[0].setSystemId(f.toURI().toString());
                return source;
            }
            Source s = this.myRepo.resolve(module_uri, URISpace.XQUERY);
            if (s != null) {
                if (!(s instanceof StreamSource)) {
                    throw new XPathException("The Source is not a StreamSource");
                }
                return new StreamSource[]{(StreamSource)s};
            }
            s = this.myParent.resolve(module_uri, URISpace.XQUERY);
            if (s != null) {
                if (!(s instanceof StreamSource)) {
                    throw new XPathException("The Source is not a StreamSource");
                }
                return new StreamSource[]{(StreamSource)s};
            }
        }
        catch (PackageException ex) {
            throw new XPathException("Error resolving the URI", (Throwable)ex);
        }
        return null;
    }
}

