/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.saxon;

import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.lib.ModuleURIResolver;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.saxon.SaxonRepository;

public class ConfigHelper {
    private final SaxonRepository myRepo;

    public ConfigHelper(SaxonRepository repo) {
        this.myRepo = repo;
    }

    public void config(Configuration config) throws PackageException {
        ModuleURIResolver xquery_resolver = this.myRepo.getModuleURIResolver();
        config.setModuleURIResolver(xquery_resolver);
        URIResolver xslt_resolver = this.myRepo.getURIResolver(URISpace.XSLT);
        config.setURIResolver(xslt_resolver);
        this.myRepo.registerExtensionFunctions(config);
    }

    public void config(Controller control) throws PackageException {
        control.setURIResolver(this.myRepo.getURIResolver(URISpace.XSLT));
    }
}

