/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.saxon;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ModuleURIResolver;
import org.expath.pkg.repo.Extension;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.Universe;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.XarFileSource;
import org.expath.pkg.repo.XarSource;
import org.expath.pkg.repo.tools.Logger;
import org.expath.pkg.saxon.PkgModuleResolver;
import org.expath.pkg.saxon.PkgURIResolver;
import org.expath.pkg.saxon.SaxonPkgExtension;
import org.expath.pkg.saxon.SaxonPkgInfo;

public class SaxonRepository {
    private Repository myParent;
    private static final String OVERRIDE_PROP = "org.expath.pkg.saxon.resolve";
    private static Map<String, String> OVERRIDES = null;
    private static final Logger LOG = Logger.getLogger(SaxonRepository.class);

    public SaxonRepository(Storage storage) throws PackageException {
        this(new Repository(storage));
    }

    public SaxonRepository(Repository parent) throws PackageException {
        this.myParent = parent;
        parent.registerExtension((Extension)new SaxonPkgExtension());
    }

    public Repository getUnderlyingRepo() {
        return this.myParent;
    }

    public Package installPackage(File pkg, boolean force, UserInteractionStrategy interact) throws PackageException {
        return this.myParent.installPackage((XarSource)new XarFileSource(pkg.toPath()), force, interact);
    }

    public Package installPackage(URI pkg, boolean force, UserInteractionStrategy interact) throws PackageException {
        return this.myParent.installPackage(pkg, force, interact);
    }

    public boolean removePackage(String pkg, boolean force, UserInteractionStrategy interact) throws PackageException {
        return this.myParent.removePackage(pkg, force, interact);
    }

    public Source resolve(String href, URISpace space) throws PackageException {
        return this.myParent.resolve(href, space);
    }

    public ModuleURIResolver getModuleURIResolver() throws PackageException {
        Map<String, String> overrides = SaxonRepository.getOverrides();
        return new PkgModuleResolver(overrides, this, this.myParent);
    }

    public URIResolver getURIResolver(URISpace space) throws PackageException {
        Map<String, String> overrides = SaxonRepository.getOverrides();
        org.expath.pkg.repo.resolver.PkgURIResolver parent = new org.expath.pkg.repo.resolver.PkgURIResolver((Universe)this.myParent, space);
        return new PkgURIResolver(overrides, this, (URIResolver)parent, space);
    }

    public void registerExtensionFunctions(Configuration config) throws PackageException {
        for (Packages pp : this.myParent.listPackages()) {
            Package pkg = pp.latest();
            SaxonPkgInfo info = (SaxonPkgInfo)pkg.getInfo("saxon");
            if (info == null) continue;
            info.registerExtensionFunctions(config);
        }
    }

    private static synchronized Map<String, String> getOverrides() throws PackageException {
        if (OVERRIDES == null) {
            OVERRIDES = SaxonRepository.parseOverrideProperty();
        }
        return OVERRIDES;
    }

    private static Map<String, String> parseOverrideProperty() throws PackageException {
        HashMap<String, String> res = new HashMap<String, String>();
        String prop = System.getProperty(OVERRIDE_PROP);
        if (prop == null || "".equals(prop)) {
            return res;
        }
        LOG.fine("Property {0} value is: {1}", new Object[]{OVERRIDE_PROP, prop});
        for (String override : prop.split(",")) {
            if (override == null || "".equals(override)) continue;
            String[] split = override.split("\\|");
            if (split == null || split.length != 2) {
                throw new PackageException("Wrong resolve value: " + prop);
            }
            res.put(split[0], split[1]);
        }
        return res;
    }
}

