/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.saxon;

import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.trans.XPathException;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.PackageInfo;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.tools.Logger;
import org.expath.pkg.saxon.EXPathFunctionDefinition;
import org.expath.tools.ToolsException;
import org.expath.tools.saxon.fun.Definition;
import org.expath.tools.saxon.fun.Function;
import org.expath.tools.saxon.fun.Library;

public class SaxonPkgInfo
extends PackageInfo {
    private final Set<String> myJars = new HashSet<String>();
    private final Set<String> myFuns = new HashSet<String>();
    private final Set<String> myLibs = new HashSet<String>();
    private final Map<String, String> myXslt = new HashMap<String, String>();
    private final Map<String, String> myXquery = new HashMap<String, String>();
    private final Map<String, String> myXsltWrappers = new HashMap<String, String>();
    private final Map<String, String> myXqueryWrappers = new HashMap<String, String>();
    private static final Logger LOG = Logger.getLogger(SaxonPkgInfo.class);
    private static final String EMPTY_STYLESHEET = "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='2.0'/>\n";

    public SaxonPkgInfo(Package pkg) {
        super("saxon", pkg);
    }

    public void registerExtensionFunctions(Configuration config) throws PackageException {
        try {
            Class<Object> c;
            ClassLoader loader;
            Class<?> clazz;
            for (String name : this.myLibs) {
                LOG.fine("Register library class {0}", new Object[]{name});
                try {
                    clazz = Class.forName(name);
                }
                catch (ClassNotFoundException ex) {
                    loader = this.getClassLoader(this.getPackage(), this.myJars);
                    clazz = Class.forName(name, true, loader);
                }
                if (Library.class.isAssignableFrom(clazz)) {
                    c = clazz.asSubclass(Library.class);
                    Library lib = c.newInstance();
                    lib.register(config);
                    continue;
                }
                throw new PackageException("Not a proper library: " + clazz);
            }
            for (String name : this.myFuns) {
                Object fun;
                LOG.fine("Register function class {0}", new Object[]{name});
                try {
                    clazz = Class.forName(name);
                }
                catch (ClassNotFoundException ex) {
                    loader = this.getClassLoader(this.getPackage(), this.myJars);
                    clazz = Class.forName(name, true, loader);
                }
                if (Function.class.isAssignableFrom(clazz)) {
                    c = clazz.asSubclass(Function.class);
                    fun = (Function)c.newInstance();
                    Definition def = fun.definition();
                    config.registerExtensionFunction((ExtensionFunctionDefinition)def);
                    continue;
                }
                if (EXPathFunctionDefinition.class.isAssignableFrom(clazz)) {
                    c = clazz.asSubclass(EXPathFunctionDefinition.class);
                    fun = (EXPathFunctionDefinition)((Object)c.newInstance());
                    ((EXPathFunctionDefinition)((Object)fun)).setConfiguration(config);
                    config.registerExtensionFunction((ExtensionFunctionDefinition)fun);
                    continue;
                }
                if (ExtensionFunctionDefinition.class.isAssignableFrom(clazz)) {
                    c = clazz.asSubclass(ExtensionFunctionDefinition.class);
                    fun = (ExtensionFunctionDefinition)c.newInstance();
                    config.registerExtensionFunction((ExtensionFunctionDefinition)fun);
                    continue;
                }
                throw new PackageException("Not a proper extension function: " + clazz);
            }
        }
        catch (ToolsException ex) {
            throw new PackageException("Error registering Java extension functions", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new PackageException("Error registering Java extension functions", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new PackageException("Error registering Java extension functions", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new PackageException("Error registering Java extension functions", (Throwable)ex);
        }
        catch (XPathException ex) {
            throw new PackageException("Error registering Java extension functions", (Throwable)ex);
        }
    }

    public Source resolve(String href, URISpace space) throws PackageException {
        Storage.PackageResolver resolver = this.getPackage().getResolver();
        if (space == URISpace.XQUERY) {
            String f = this.myXquery.get(href);
            if (f != null) {
                try {
                    return resolver.resolveComponent(f);
                }
                catch (Storage.NotExistException ex) {
                    throw new PackageException("Query not found in the package", (Throwable)ex);
                }
            }
            f = this.myXqueryWrappers.get(href);
            if (f != null) {
                try {
                    return this.resolveXqueryWrapper(href);
                }
                catch (XPathException ex) {
                    throw new PackageException("Error resolving the URI: " + href, (Throwable)ex);
                }
            }
        } else if (space == URISpace.XSLT) {
            String f = this.myXslt.get(href);
            if (f != null) {
                try {
                    return resolver.resolveComponent(f);
                }
                catch (Storage.NotExistException ex) {
                    throw new PackageException("Stylesheet not found in the package", (Throwable)ex);
                }
            }
            f = this.myXsltWrappers.get(href);
            if (f != null) {
                return this.resolveXsltWrapper(href);
            }
        }
        return null;
    }

    private Source resolveXsltWrapper(String href) {
        StringReader r = new StringReader(EMPTY_STYLESHEET);
        return new StreamSource(r);
    }

    private Source resolveXqueryWrapper(String href) throws XPathException {
        String module = "module namespace tns = '" + href + "';\n";
        StringReader r = new StringReader(module);
        StreamSource src = new StreamSource(r);
        src.setSystemId("http://expath.org/pkg/saxon/xquery#empty");
        return src;
    }

    private ClassLoader getClassLoader(Package pkg, Set<String> jars) throws XPathException, PackageException {
        ArrayList<URL> cp = new ArrayList<URL>();
        Storage.PackageResolver resolver = pkg.getResolver();
        for (String j : jars) {
            try {
                Source src = resolver.resolveComponent(j);
                String sysid = src.getSystemId();
                cp.add(new URL(sysid));
            }
            catch (Storage.NotExistException ex) {
                throw new PackageException("JAR not found in the package", (Throwable)ex);
            }
            catch (MalformedURLException ex) {
                throw new XPathException("The file does not result in a valid URI", (Throwable)ex);
            }
        }
        LOG.fine("Use the following CP for registerExtensionFunctions: {0}", new Object[]{cp});
        try {
            ClassLoader parent = SaxonPkgInfo.class.getClassLoader();
            return new URLClassLoader(cp.toArray(new URL[0]), parent);
        }
        catch (AccessControlException ex) {
            LOG.info("Access control error: {0}", new Object[]{ex});
            return null;
        }
    }

    public boolean hasJars() {
        return !this.myJars.isEmpty();
    }

    public Set<String> getJars() {
        return this.myJars;
    }

    public void addJar(String jar) {
        this.myJars.add(jar);
    }

    public void addFunction(String fun) {
        this.myFuns.add(fun);
    }

    public void addLibrary(String lib) {
        this.myLibs.add(lib);
    }

    public void addXslt(String href, String file) {
        this.myXslt.put(href, file);
    }

    public void addXQuery(String href, String file) {
        this.myXquery.put(href, file);
    }

    public void addXsltWrapper(String href, String file) {
        this.myXsltWrappers.put(href, file);
    }

    public void addXQueryWrapper(String href, String file) {
        this.myXqueryWrappers.put(href, file);
    }
}

