/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.saxon;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.expath.pkg.repo.DescriptorExtension;
import org.expath.pkg.repo.FileSystemStorage;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.PackageInfo;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.parser.XMLStreamHelper;
import org.expath.pkg.saxon.SaxonPkgInfo;

public class SaxonPkgExtension
extends DescriptorExtension {
    public static final String CLASSPATH_FILE = ".saxon/classpath.txt";
    public static final String SAXON_PKG_NS = "http://saxon.sf.net/ns/expath-pkg";
    private final XMLStreamHelper myXSHelper = new XMLStreamHelper("http://saxon.sf.net/ns/expath-pkg");

    public SaxonPkgExtension() {
        super("saxon", "saxon.xml");
    }

    protected void parseDescriptor(XMLStreamReader parser, Package pkg) throws PackageException {
        this.myXSHelper.ensureNextElement(parser, "package");
        SaxonPkgInfo info = new SaxonPkgInfo(pkg);
        try {
            parser.next();
            while (parser.getEventType() == 1) {
                if (!SAXON_PKG_NS.equals(parser.getNamespaceURI())) {
                    throw new PackageException("TODO: Ignore elements in other namespace");
                }
                this.handleElement(parser, info);
                parser.next();
            }
            parser.next();
        }
        catch (XMLStreamException ex) {
            throw new PackageException("Error reading the saxon descriptor", (Throwable)ex);
        }
        pkg.addInfo(this.getName(), (PackageInfo)info);
    }

    private void handleElement(XMLStreamReader parser, SaxonPkgInfo info) throws PackageException, XMLStreamException {
        String local = parser.getLocalName();
        if ("jar".equals(local)) {
            String jar = this.myXSHelper.getElementValue(parser);
            info.addJar(jar);
        } else if ("function".equals(local)) {
            String fun = this.myXSHelper.getElementValue(parser);
            info.addFunction(fun);
        } else if ("library".equals(local)) {
            String lib = this.myXSHelper.getElementValue(parser);
            info.addLibrary(lib);
        } else if ("xslt".equals(local)) {
            Mapping m = this.handleMapping(parser, "import-uri");
            info.addXslt(m.href, m.file);
        } else if ("xquery".equals(local)) {
            Mapping m = this.handleMapping(parser, "namespace");
            info.addXQuery(m.href, m.file);
        } else if ("xslt-wrapper".equals(local)) {
            Mapping m = this.handleMapping(parser, "import-uri");
            info.addXsltWrapper(m.href, m.file);
        } else if ("xquery-wrapper".equals(local)) {
            Mapping m = this.handleMapping(parser, "namespace");
            info.addXQueryWrapper(m.href, m.file);
        } else {
            throw new PackageException("Unknown Saxon component type: " + local);
        }
    }

    private Mapping handleMapping(XMLStreamReader parser, String uri_name) throws PackageException, XMLStreamException {
        this.myXSHelper.ensureNextElement(parser, uri_name);
        String href = this.myXSHelper.getElementValue(parser);
        this.myXSHelper.ensureNextElement(parser, "file");
        String file = this.myXSHelper.getElementValue(parser);
        parser.next();
        return new Mapping(href, file);
    }

    public void install(Repository repo, Package pkg) throws PackageException {
        this.init(repo, pkg);
        SaxonPkgInfo info = this.getInfo(pkg);
        if (info == null) {
            return;
        }
        if (!info.hasJars()) {
            return;
        }
        this.setupClasspath(pkg, info);
    }

    private SaxonPkgInfo getInfo(Package pkg) throws PackageException {
        PackageInfo info = pkg.getInfo(this.getName());
        if (info == null) {
            return null;
        }
        if (!(info instanceof SaxonPkgInfo)) {
            throw new PackageException("Not a Saxon-specific package info: " + info.getClass());
        }
        return (SaxonPkgInfo)info;
    }

    private void setupClasspath(Package pkg, SaxonPkgInfo info) throws PackageException {
        File classpath = this.createClasspathFile(pkg);
        if (classpath == null) {
            return;
        }
        Storage.PackageResolver res = pkg.getResolver();
        try {
            FileWriter out = new FileWriter(classpath);
            for (String jar : info.getJars()) {
                try {
                    res.resolveComponent(jar);
                }
                catch (Storage.NotExistException ex) {
                    throw new PackageException("The Saxon descriptor refers to a JAR file that does not exist: " + jar, (Throwable)ex);
                }
                out.write(jar);
                out.write("\n");
            }
            out.close();
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the Saxon classpath file: " + classpath, (Throwable)ex);
        }
    }

    private File createClasspathFile(Package pkg) throws PackageException {
        try {
            pkg.getResolver().resolveResource(CLASSPATH_FILE);
            return null;
        }
        catch (Storage.NotExistException notExistException) {
            FileSystemStorage.FileSystemResolver res = this.getFileSystemResolver(pkg);
            File classpath = res.resolveResourceAsFile(CLASSPATH_FILE).toFile();
            File saxon = classpath.getParentFile();
            if (saxon.exists()) {
                if (!saxon.isDirectory()) {
                    throw new PackageException("Private dir is not a directory: " + saxon);
                }
            } else if (!saxon.mkdir()) {
                throw new PackageException("Impossible to create directory: " + saxon);
            }
            return classpath;
        }
    }

    private FileSystemStorage.FileSystemResolver getFileSystemResolver(Package pkg) throws PackageException {
        Storage.PackageResolver res = pkg.getResolver();
        if (res == null) {
            throw new PackageException("Resolver is null on package: " + pkg.getName());
        }
        if (!(res instanceof FileSystemStorage.FileSystemResolver)) {
            throw new PackageException("Not a file system resolver: " + res.getClass());
        }
        return (FileSystemStorage.FileSystemResolver)res;
    }

    private static class Mapping {
        public String href;
        public String file;

        public Mapping(String h, String f) {
            this.href = h;
            this.file = f;
        }
    }
}

