/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.calabash;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class PkgReadableDocument
implements ReadablePipe {
    private String myHref;
    private URIResolver myResolver;
    private XProcRuntime myRuntime;
    private int myPos = 0;
    private DocumentSequence myDocs = null;
    private boolean myHasBeenRead = false;

    public PkgReadableDocument(String href, URIResolver resolver, XProcRuntime runtime) {
        this.myHref = href;
        this.myResolver = resolver;
        this.myRuntime = runtime;
        this.myDocs = new DocumentSequence(this.myRuntime);
    }

    public void canReadSequence(boolean sequence) {
    }

    public void resetReader() {
        this.myPos = 0;
    }

    public void setReader(Step step) {
    }

    public boolean moreDocuments() {
        if (!this.myHasBeenRead) {
            this.doRead();
        }
        return this.myPos < this.myDocs.size();
    }

    public boolean closed() {
        return true;
    }

    public int documentCount() {
        return this.myDocs.size();
    }

    public DocumentSequence documents() {
        return this.myDocs;
    }

    public XdmNode read() throws SaxonApiException {
        if (!this.myHasBeenRead) {
            this.doRead();
        }
        return this.myDocs.get(this.myPos++);
    }

    public boolean readSequence() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setNames(String step, String port) {
    }

    private void doRead() {
        Source src;
        try {
            src = this.myResolver.resolve(this.myHref, null);
        }
        catch (TransformerException ex) {
            throw new XProcException("Error resolving '" + this.myHref + "'", (Throwable)ex);
        }
        DocumentBuilder builder = this.myRuntime.getProcessor().newDocumentBuilder();
        builder.setLineNumbering(true);
        try {
            this.myDocs.add(builder.build(src));
            this.myHasBeenRead = true;
        }
        catch (SaxonApiException ex) {
            String msg = "Error building '" + this.myHref + "' (" + src.getSystemId() + ")";
            throw new XProcException(msg, (Throwable)ex);
        }
    }
}

