/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.calabash;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PkgReadableData
implements ReadablePipe {
    private String myHref;
    private QName myWrapper;
    private String myConType;
    private EntityResolver myResolver;
    private XProcRuntime myRuntime;
    private int myPos = 0;
    private DocumentSequence myDocs = null;

    public PkgReadableData(String href, QName wrapper, String content_type, EntityResolver resolver, XProcRuntime runtime) {
        URI uri;
        InputSource src;
        this.myHref = href;
        this.myWrapper = wrapper;
        this.myConType = content_type;
        this.myResolver = resolver;
        this.myRuntime = runtime;
        this.myDocs = new DocumentSequence(this.myRuntime);
        String user_con_type = this.parseContentType(this.myConType);
        String user_charset = this.parseCharset(this.myConType);
        if (this.myHref == null) {
            return;
        }
        try {
            src = this.myResolver.resolveEntity(null, this.myHref);
            if (src == null) {
                throw new XProcException("Data not found (" + this.myHref + ")");
            }
        }
        catch (SAXException ex) {
            throw new XProcException("Error resolving the URI (" + this.myHref + ")", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new XProcException("Error resolving the URI (" + this.myHref + ")", (Throwable)ex);
        }
        try {
            uri = new URI(src.getSystemId());
        }
        catch (URISyntaxException ex) {
            throw new XProcException("Not a proper URI (" + this.myHref + ")", (Throwable)ex);
        }
        TreeWriter tree = new TreeWriter(runtime);
        tree.startDocument(uri);
        try {
            String server_charset;
            String server_con_type;
            InputStream stream = src.getByteStream();
            String string = server_con_type = this.myConType == null ? "text/plain" : this.myConType;
            if ("content/unknown".equals(server_con_type) && this.myConType != null) {
                server_con_type = this.myConType;
            }
            String server_base_con_type = this.parseContentType(server_con_type);
            String charset = server_charset = this.parseCharset(server_con_type);
            if (server_charset == null && server_base_con_type.equals(user_con_type)) {
                charset = user_charset;
            }
            tree.addStartElement(wrapper);
            if (XProcConstants.c_data.equals((Object)wrapper)) {
                if ("content/unknown".equals(server_con_type)) {
                    tree.addAttribute(ReadableData._contentType, "application/octet-stream");
                } else {
                    tree.addAttribute(ReadableData._contentType, server_con_type);
                }
                if (!this.isText(server_con_type, charset)) {
                    tree.addAttribute(ReadableData._encoding, "base64");
                }
            } else {
                if ("content/unknown".equals(server_con_type)) {
                    tree.addAttribute(ReadableData.c_contentType, "application/octet-stream");
                } else {
                    tree.addAttribute(ReadableData.c_contentType, server_con_type);
                }
                if (!this.isText(server_con_type, charset)) {
                    tree.addAttribute(ReadableData.c_encoding, "base64");
                }
            }
            tree.startContent();
            if (this.isText(server_con_type, charset)) {
                if (charset == null) {
                    charset = "UTF-8";
                }
                BufferedReader bufreader = new BufferedReader(new InputStreamReader(stream, charset));
                int buflen = 12288;
                char[] chars = new char[buflen];
                int read = bufreader.read(chars, 0, buflen);
                while (read >= 0) {
                    if (read > 0) {
                        String data = new String(chars, 0, read);
                        tree.addText(data);
                    }
                    read = bufreader.read(chars, 0, buflen);
                }
                bufreader.close();
            } else {
                int buflen = 12288;
                byte[] bytes = new byte[buflen];
                int pos = 0;
                int readlen = buflen;
                boolean done = false;
                while (!done) {
                    int read = stream.read(bytes, pos, readlen);
                    if (read >= 0) {
                        pos += read;
                        readlen -= read;
                    } else {
                        done = true;
                    }
                    if (readlen != 0 && !done) continue;
                    String base64 = Base64.encodeBytes((byte[])bytes, (int)0, (int)pos);
                    tree.addText(base64 + "\n");
                    pos = 0;
                    readlen = buflen;
                }
                stream.close();
            }
        }
        catch (IOException ex) {
            throw new XProcException("Error reading the data content", (Throwable)ex);
        }
        tree.addEndElement();
        tree.endDocument();
        XdmNode doc = tree.getResult();
        this.myDocs.add(doc);
    }

    public void canReadSequence(boolean sequence) {
    }

    public void resetReader() {
        this.myPos = 0;
    }

    public void setReader(Step step) {
    }

    public boolean moreDocuments() {
        return this.myPos < this.myDocs.size();
    }

    public boolean closed() {
        return true;
    }

    public int documentCount() {
        return this.myDocs.size();
    }

    public DocumentSequence documents() {
        return this.myDocs;
    }

    public XdmNode read() throws SaxonApiException {
        return this.myDocs.get(this.myPos++);
    }

    public boolean readSequence() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setNames(String step, String port) {
    }

    private boolean isText(String content_type, String charset) {
        return "application/xml".equals(content_type) || content_type.endsWith("+xml") || content_type.startsWith("text/") || "utf-8".equals(charset);
    }

    private String parseContentType(String content_type) {
        if (content_type == null) {
            return null;
        }
        int pos = content_type.indexOf(";");
        if (pos > 0) {
            String type = content_type.substring(0, pos).trim();
            return type;
        }
        return content_type;
    }

    private String parseCharset(String content_type) {
        if (content_type == null) {
            return null;
        }
        int pos = content_type.indexOf(";");
        if (pos > 0) {
            String charset = content_type.substring(pos);
            if ((charset = charset.replaceAll(";\\s+", ";").replaceAll("\\s+;", ";")).contains(";charset=")) {
                pos = charset.indexOf(";charset=");
                if ((pos = (charset = charset.substring(pos + 9)).indexOf(";")) >= 0) {
                    charset = charset.substring(0, pos);
                }
                return charset.toLowerCase();
            }
        }
        return null;
    }
}

