/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.calabash;

import com.xmlcalabash.config.JaxpConfigurer;
import com.xmlcalabash.config.JingConfigurer;
import com.xmlcalabash.config.SaxonConfigurer;
import com.xmlcalabash.config.XMLCalabashConfigurer;
import com.xmlcalabash.config.XProcConfigurer;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import java.io.File;
import org.expath.pkg.calabash.PkgCalabashConfigurer;
import org.expath.pkg.calabash.PkgJaxpConfigurer;
import org.expath.pkg.calabash.PkgJingConfigurer;
import org.expath.pkg.calabash.PkgSaxonConfigurer;
import org.expath.pkg.repo.FileSystemStorage;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkgConfigurer
implements XProcConfigurer {
    private XProcRuntime myRuntime;
    private Repository myRepo;
    private XMLCalabashConfigurer myCalabash = null;
    private JaxpConfigurer myJaxp = null;
    private JingConfigurer myJing = null;
    private SaxonConfigurer mySaxon = null;
    private static final Logger LOG = LoggerFactory.getLogger(PkgConfigurer.class);

    public PkgConfigurer(XProcRuntime runtime) {
        this.myRuntime = runtime;
        String repo_value = System.getProperty("org.expath.pkg.calabash.repo");
        LOG.debug("org.expath.pkg.calabash.repo: {}", (Object)repo_value);
        if (repo_value == null) {
            repo_value = System.getenv("EXPATH_REPO");
            LOG.debug("$EXPATH_REPO: {}", (Object)repo_value);
        }
        if (repo_value == null) {
            LOG.error("Unable to locate the EXPath repository, cannot set up packaging");
            LOG.error("Use ++repo, org.expath.pkg.calabash.repo, or $EXPATH_REPO to enable it");
            return;
        }
        LOG.info("Initialize EXPath Packaging with: {}", (Object)repo_value);
        try {
            FileSystemStorage storage = new FileSystemStorage(new File(repo_value).toPath());
            this.myRepo = new Repository((Storage)storage);
        }
        catch (PackageException ex) {
            throw new XProcException("Error instantiating the EXPath repository on " + repo_value, (Throwable)ex);
        }
    }

    public PkgConfigurer(XProcRuntime runtime, Repository repo) {
        this.myRuntime = runtime;
        this.myRepo = repo;
    }

    public XMLCalabashConfigurer getXMLCalabashConfigurer() {
        if (this.myCalabash == null) {
            this.myCalabash = new PkgCalabashConfigurer(this.myRuntime, this.myRepo);
        }
        return this.myCalabash;
    }

    public JaxpConfigurer getJaxpConfigurer() {
        if (this.myJaxp == null) {
            this.myJaxp = new PkgJaxpConfigurer(this.myRepo);
        }
        return this.myJaxp;
    }

    public JingConfigurer getJingConfigurer() {
        if (this.myJing == null) {
            this.myJing = new PkgJingConfigurer(this.myRepo);
        }
        return this.myJing;
    }

    public SaxonConfigurer getSaxonConfigurer() {
        if (this.mySaxon == null) {
            try {
                this.mySaxon = new PkgSaxonConfigurer(this.myRepo);
            }
            catch (PackageException ex) {
                throw new RuntimeException("FIXME: Implement proper error mgmt", ex);
            }
        }
        return this.mySaxon;
    }
}

