/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.calabash;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.library.Load;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.util.DefaultXMLCalabashConfigurer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.expath.pkg.calabash.CalabashPkgInfo;
import org.expath.pkg.calabash.PkgReadableData;
import org.expath.pkg.calabash.PkgReadableDocument;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Packages;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.Universe;
import org.expath.pkg.repo.resolver.PkgEntityResolver;
import org.expath.pkg.repo.resolver.PkgURIResolver;
import org.xml.sax.EntityResolver;

public class PkgCalabashConfigurer
extends DefaultXMLCalabashConfigurer {
    private Repository myRepo;
    private static final QName KIND = new QName("pkg", "http://expath.org/ns/pkg", "kind");
    private static final QName HREF = new QName("href");
    private static final QName DTD_VAL = new QName("dtd-validate");

    public PkgCalabashConfigurer(XProcRuntime runtime, Repository repo) {
        super(runtime);
        this.myRepo = repo;
    }

    public void configRuntime(XProcRuntime runtime) {
        PkgURIResolver resolver = new PkgURIResolver((Universe)this.myRepo, URISpace.XPROC);
        runtime.setURIResolver((URIResolver)resolver);
        for (Packages pp : this.myRepo.listPackages()) {
            Package pkg = pp.latest();
            CalabashPkgInfo info = (CalabashPkgInfo)pkg.getInfo("calabash");
            if (info == null) continue;
            try {
                info.registerExtensionSteps(runtime);
            }
            catch (PackageException ex) {
                String msg = "Error registering extension steps for ";
                throw new XProcException(msg + pkg.getName() + ", " + pkg.getVersion(), (Throwable)ex);
            }
        }
    }

    public XdmNode loadDocument(Load step) {
        String kind = step.getStep().getExtensionAttribute(KIND);
        if (kind == null) {
            return super.loadDocument(step);
        }
        boolean validate = step.getOption(DTD_VAL, false);
        String href = step.getOption(HREF).getString();
        XdmNode doc = this.parse(href, validate, kind);
        if (doc == null) {
            return super.loadDocument(step);
        }
        return doc;
    }

    public ReadablePipe makeReadableData(XProcRuntime r, DataBinding b) {
        String kind = b.getExtensionAttribute(KIND);
        if (kind == null) {
            return super.makeReadableData(r, b);
        }
        EntityResolver resolver = this.getEntityResolver(kind);
        return new PkgReadableData(b.getHref(), b.getWrapper(), b.getContentType(), resolver, r);
    }

    public ReadablePipe makeReadableDocument(XProcRuntime r, DocumentBinding b) {
        String kind = b.getExtensionAttribute(KIND);
        if (kind == null) {
            return super.makeReadableDocument(r, b);
        }
        URIResolver resolver = this.getURIResolver(kind);
        return new PkgReadableDocument(b.getHref(), resolver, r);
    }

    private XdmNode parse(String href, boolean validate, String kind) {
        try {
            URIResolver resolver = this.getURIResolver(kind);
            Source src = resolver.resolve(href, null);
            if (src == null) {
                return null;
            }
            DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
            builder.setDTDValidation(validate);
            builder.setLineNumbering(true);
            return builder.build(src);
        }
        catch (TransformerException ex) {
            throw new XProcException("Error resolving " + href + " (" + kind + ")", (Throwable)ex);
        }
        catch (SaxonApiException ex) {
            throw new XProcException("Error building " + href + " (" + kind + ")", (Throwable)ex);
        }
    }

    private URIResolver getURIResolver(String kind) {
        return new PkgURIResolver((Universe)this.myRepo, this.spaceFromKind(kind));
    }

    private EntityResolver getEntityResolver(String kind) {
        return new PkgEntityResolver((Universe)this.myRepo, this.spaceFromKind(kind));
    }

    private URISpace spaceFromKind(String kind) {
        return URISpace.valueOf((String)kind.toUpperCase());
    }
}

