/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.calabash;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcRuntime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.QName;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.PackageInfo;
import org.expath.pkg.repo.URISpace;

public class CalabashPkgInfo
extends PackageInfo {
    private Set<String> myJars = new HashSet<String>();
    private Map<QName, String> mySteps = new HashMap<QName, String>();

    public CalabashPkgInfo(Package pkg) {
        super("calabash", pkg);
    }

    public void registerExtensionSteps(XProcRuntime runtime) throws PackageException {
        XProcConfiguration config = runtime.getConfiguration();
        for (Map.Entry<QName, String> e : this.mySteps.entrySet()) {
            QName key = e.getKey();
            String value = e.getValue();
            Class clazz = this.loadClass(value);
            config.implementations.put(key, clazz);
        }
    }

    public StreamSource resolve(String href, URISpace space) throws PackageException {
        return null;
    }

    public boolean hasJars() {
        return !this.myJars.isEmpty();
    }

    public Set<String> getJars() {
        return this.myJars;
    }

    public void addJar(String jar) {
        this.myJars.add(jar);
    }

    public void addStep(QName type, String clazz) {
        this.mySteps.put(type, clazz);
    }

    private Class loadClass(String name) throws PackageException {
        ClassLoader loader = CalabashPkgInfo.class.getClassLoader();
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            throw new PackageException("Class not found: '" + name + "'", (Throwable)ex);
        }
    }
}

