/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.calabash;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import net.sf.saxon.s9api.QName;
import org.expath.pkg.calabash.CalabashPkgInfo;
import org.expath.pkg.repo.DescriptorExtension;
import org.expath.pkg.repo.FileSystemStorage;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.PackageInfo;
import org.expath.pkg.repo.Repository;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.parser.XMLStreamHelper;

public class CalabashPkgExtension
extends DescriptorExtension {
    public static final String CLASSPATH_FILE = ".calabash/classpath.txt";
    public static final String CALABASH_PKG_NS = "http://xmlcalabash.com/ns/expath-pkg";
    private final XMLStreamHelper myXSHelper = new XMLStreamHelper("http://xmlcalabash.com/ns/expath-pkg");

    public CalabashPkgExtension() {
        super("calabash", "calabash.xml");
    }

    protected void parseDescriptor(XMLStreamReader parser, Package pkg) throws PackageException {
        this.myXSHelper.ensureNextElement(parser, "package");
        CalabashPkgInfo info = new CalabashPkgInfo(pkg);
        try {
            parser.next();
            while (parser.getEventType() == 1) {
                if (!CALABASH_PKG_NS.equals(parser.getNamespaceURI())) {
                    throw new PackageException("TODO: Ignore elements in other namespace");
                }
                this.handleElement(parser, info);
                parser.next();
            }
            parser.next();
        }
        catch (XMLStreamException ex) {
            throw new PackageException("Error reading the saxon descriptor", (Throwable)ex);
        }
        pkg.addInfo(this.getName(), (PackageInfo)info);
    }

    private void handleElement(XMLStreamReader parser, CalabashPkgInfo info) throws PackageException, XMLStreamException {
        String local = parser.getLocalName();
        if ("jar".equals(local)) {
            String jar = this.myXSHelper.getElementValue(parser);
            info.addJar(jar);
        } else if ("step".equals(local)) {
            this.myXSHelper.ensureNextElement(parser, "type");
            String type = this.myXSHelper.getElementValue(parser);
            this.myXSHelper.ensureNextElement(parser, "class");
            String clazz = this.myXSHelper.getElementValue(parser);
            parser.next();
            QName qname = QName.fromClarkName((String)type);
            info.addStep(qname, clazz);
        } else {
            throw new PackageException("Unknown Calabash component type: " + local);
        }
    }

    public void install(Repository repo, Package pkg) throws PackageException {
        this.init(repo, pkg);
        CalabashPkgInfo info = this.getInfo(pkg);
        if (info == null) {
            return;
        }
        if (!info.hasJars()) {
            return;
        }
        this.setupClasspath(pkg, info);
    }

    private CalabashPkgInfo getInfo(Package pkg) throws PackageException {
        PackageInfo info = pkg.getInfo(this.getName());
        if (info == null) {
            return null;
        }
        if (!(info instanceof CalabashPkgInfo)) {
            throw new PackageException("Not a Calabash-specific package info: " + info.getClass());
        }
        return (CalabashPkgInfo)info;
    }

    private void setupClasspath(Package pkg, CalabashPkgInfo info) throws PackageException {
        File classpath = this.createClasspathFile(pkg);
        if (classpath == null) {
            return;
        }
        Storage.PackageResolver res = pkg.getResolver();
        try {
            FileWriter out = new FileWriter(classpath);
            for (String jar : info.getJars()) {
                Source jar_src = res.resolveComponent(jar);
                String sysid = jar_src.getSystemId();
                URI uri = URI.create(sysid);
                File file = new File(uri);
                out.write(file.getCanonicalPath());
                out.write("\n");
            }
            out.close();
        }
        catch (Storage.NotExistException ex) {
            throw new PackageException("The Calabash descriptor refers to an inexistent JAR", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the Calabash classpath file: " + classpath, (Throwable)ex);
        }
    }

    private File createClasspathFile(Package pkg) throws PackageException {
        try {
            pkg.getResolver().resolveResource(CLASSPATH_FILE);
            return null;
        }
        catch (Storage.NotExistException notExistException) {
            FileSystemStorage.FileSystemResolver res = this.getFileSystemResolver(pkg);
            File classpath = res.resolveResourceAsFile(CLASSPATH_FILE).toFile();
            File calabash = classpath.getParentFile();
            if (calabash.exists()) {
                if (!calabash.isDirectory()) {
                    throw new PackageException("Private dir is not a directory: " + calabash);
                }
            } else if (!calabash.mkdir()) {
                throw new PackageException("Impossible to create directory: " + calabash);
            }
            return classpath;
        }
    }

    private FileSystemStorage.FileSystemResolver getFileSystemResolver(Package pkg) throws PackageException {
        Storage.PackageResolver res = pkg.getResolver();
        if (res == null) {
            throw new PackageException("Resolver is null on package: " + pkg.getName());
        }
        if (!(res instanceof FileSystemStorage.FileSystemResolver)) {
            throw new PackageException("Not a file system resolver: " + res.getClass());
        }
        return (FileSystemStorage.FileSystemResolver)res;
    }
}

