/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.expath.httpclient.ContentType;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpResponseBody;
import org.expath.httpclient.impl.BinaryResponseBody;
import org.expath.httpclient.impl.BodyFactory;
import org.expath.httpclient.impl.TextResponseBody;
import org.expath.httpclient.impl.XmlResponseBody;
import org.expath.httpclient.model.Result;
import org.expath.httpclient.model.TreeBuilder;
import org.expath.tools.ToolsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartResponseBody
implements HttpResponseBody {
    private List<HttpResponseBody> myParts;
    private ContentType myContentType;
    private String myBoundary;
    private static final Logger LOG = LoggerFactory.getLogger(MultipartResponseBody.class);

    public MultipartResponseBody(Result result, InputStream in, ContentType type) throws HttpClientException {
        if (type == null || type.getType() == null) {
            throw new HttpClientException("No content type");
        }
        this.myContentType = type;
        this.myParts = new ArrayList<HttpResponseBody>();
        this.myBoundary = type.getBoundary();
        if (this.myBoundary == null) {
            throw new HttpClientException("No boundary");
        }
        try {
            this.analyzeParts(result, in);
        }
        catch (IOException ex) {
            throw new HttpClientException("error reading the response stream", ex);
        }
    }

    @Override
    public void outputBody(TreeBuilder b) throws HttpClientException {
        try {
            b.startElem("multipart");
            b.attribute("media-type", this.myContentType.getValue());
            b.attribute("boundary", this.myBoundary);
            b.startContent();
            for (HttpResponseBody part : this.myParts) {
                part.outputBody(b);
            }
            b.endElem();
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Error building the body", ex);
        }
    }

    private void analyzeParts(Result result, InputStream in) throws IOException, HttpClientException {
        MimeTokenStream parser = new MimeTokenStream();
        String contentType = this.myContentType.getCharset() != null ? this.myContentType.getType() + "; charset=" + this.myContentType.getCharset() : this.myContentType.getType();
        parser.parseHeadless(in, contentType);
        try {
            HeaderSet headers = null;
            EntityState state = parser.getState();
            while (state != EntityState.T_END_OF_STREAM) {
                if (state == EntityState.T_START_HEADER) {
                    headers = new HeaderSet();
                }
                this.handleParserState(result, parser, headers);
                state = parser.next();
            }
        }
        catch (MimeException ex) {
            throw new HttpClientException("The response content is ill-formed.", ex);
        }
    }

    private void handleParserState(Result result, MimeTokenStream parser, HeaderSet headers) throws HttpClientException {
        EntityState state = parser.getState();
        if (LOG.isDebugEnabled()) {
            LOG.debug(MimeTokenStream.stateToString((EntityState)state));
        }
        switch (state) {
            case T_END_HEADER: {
                break;
            }
            case T_FIELD: {
                Field f = parser.getField();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  field: " + f);
                }
                headers.add(f.getName(), this.parseFieldBody(f));
                break;
            }
            case T_BODY: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  body desc: " + parser.getBodyDescriptor());
                }
                HttpResponseBody b = this.makeResponsePart(result, headers, parser);
                this.myParts.add(b);
                break;
            }
            case T_START_HEADER: 
            case T_END_BODYPART: 
            case T_END_MESSAGE: 
            case T_END_MULTIPART: 
            case T_EPILOGUE: 
            case T_PREAMBLE: 
            case T_START_BODYPART: 
            case T_START_MESSAGE: 
            case T_START_MULTIPART: {
                break;
            }
            default: {
                String s = MimeTokenStream.stateToString((EntityState)state);
                throw new HttpClientException("Unknown parsing state: " + s);
            }
        }
    }

    private String parseFieldBody(Field f) {
        String b = f.getBody();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Field: " + f.getName() + ": [" + b + "]");
        }
        return b;
    }

    private HttpResponseBody makeResponsePart(Result result, HeaderSet headers, MimeTokenStream parser) throws HttpClientException {
        Header h = headers.getFirstHeader("Content-Type");
        if (h == null) {
            throw new HttpClientException("impossible to find the content type");
        }
        ContentType type = ContentType.parse(h, null, null);
        try {
            switch (BodyFactory.parseType(type)) {
                case XML: {
                    Reader in = parser.getReader();
                    return new XmlResponseBody(result, in, type, headers, false);
                }
                case HTML: {
                    Reader in = parser.getReader();
                    return new XmlResponseBody(result, in, type, headers, true);
                }
                case TEXT: {
                    Reader in = parser.getReader();
                    return new TextResponseBody(result, in, type, headers);
                }
                case BINARY: {
                    InputStream in = parser.getInputStream();
                    return new BinaryResponseBody(result, in, type, headers);
                }
            }
            throw new HttpClientException("INTERNAL ERROR: cannot happen");
        }
        catch (UnsupportedEncodingException ex) {
            throw new HttpClientException("Unable to parse response part", ex);
        }
    }
}

