/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpConstants;
import org.expath.httpclient.HttpRequestBody;
import org.expath.httpclient.impl.BodyFactory;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;

public class MultipartRequestBody
extends HttpRequestBody {
    private String myBoundary;
    private byte[] myBoundaryBytes;
    private List<Body> myBodies;
    private static final byte[] DASHES = new byte[]{45, 45};
    private static final byte[] NEWLINE = new byte[]{13, 10};
    private static final byte[] COLON = new byte[]{58, 32};

    public MultipartRequestBody(Element elem, Sequence bodies, String ns) throws HttpClientException {
        super(elem);
        this.myBoundary = elem.getAttribute("boundary");
        if (this.myBoundary == null) {
            throw new HttpClientException("@boundary is not on the multipart element");
        }
        this.myBoundaryBytes = this.myBoundary.getBytes();
        try {
            elem.noOtherNCNameAttribute(HttpConstants.MULTIPART_ATTRS, HttpConstants.BOTH_NS_URIS);
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Invalid attributes", ex);
        }
        this.myBodies = new ArrayList<Body>();
        this.accumulateBodies(elem, bodies, ns);
        if (this.myBodies.isEmpty()) {
            throw new HttpClientException("http:multipart does not contain any http:body");
        }
    }

    @Override
    public void setHeaders(HeaderSet headers) throws HttpClientException {
        if (headers.getFirstHeader("Content-Type") == null) {
            StringBuilder type = new StringBuilder(this.getContentType());
            type.append("; boundary=");
            type.append("\"");
            if (this.myBoundary.contains("\"")) {
                type.append(this.myBoundary.replace("\"", "\\\""));
            } else {
                type.append(this.myBoundary);
            }
            type.append("\"");
            headers.add("Content-Type", type.toString());
        }
    }

    @Override
    public void serialize(OutputStream out) throws HttpClientException {
        try {
            for (Body body : this.myBodies) {
                out.write(DASHES);
                out.write(this.myBoundaryBytes);
                out.write(NEWLINE);
                body.myBody.setHeaders(body.myHeaders);
                this.serializePartHeaders(out, body.myHeaders);
                out.write(NEWLINE);
                body.myBody.serialize(out);
                out.write(NEWLINE);
            }
            out.write(DASHES);
            out.write(this.myBoundaryBytes);
            out.write(DASHES);
            out.write(NEWLINE);
        }
        catch (IOException ex) {
            throw new HttpClientException("IO error serializing multipart content", ex);
        }
    }

    @Override
    public boolean isMultipart() {
        return true;
    }

    private void accumulateBodies(Element elem, Sequence bodies, String ns) throws HttpClientException {
        if (elem.hasNoNsChild()) {
            String msg = "A child element of http:multipart is in no namespace.";
            throw new HttpClientException(msg);
        }
        HeaderSet headers = new HeaderSet();
        for (Element b : elem.children(ns)) {
            String name;
            if ("header".equals(b.getLocalName())) {
                try {
                    b.noOtherNCNameAttribute(HttpConstants.HEADER_ATTRS, HttpConstants.BOTH_NS_URIS);
                }
                catch (ToolsException ex) {
                    throw new HttpClientException("Invalid attributes", ex);
                }
                name = b.getAttribute("name");
                String value = b.getAttribute("value");
                headers.add(name, value);
                continue;
            }
            if ("body".equals(b.getLocalName())) {
                HttpRequestBody req_body = BodyFactory.makeRequestBody(b, bodies, ns);
                this.myBodies.add(new Body(headers, req_body));
                headers = new HeaderSet();
                continue;
            }
            name = b.getDisplayName();
            throw new HttpClientException("Unknown http:multipart child: " + name);
        }
    }

    private void serializePartHeaders(OutputStream out, HeaderSet headers) throws IOException {
        for (Header h : headers) {
            out.write(h.getName().getBytes("US-ASCII"));
            out.write(COLON);
            out.write(h.getValue().getBytes("US-ASCII"));
            out.write(NEWLINE);
        }
    }

    private static class Body {
        public HeaderSet myHeaders;
        public HttpRequestBody myBody;

        public Body(HeaderSet headers, HttpRequestBody body) {
            this.myBody = body;
            this.myHeaders = headers;
        }
    }
}

