/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.cookie.Cookie;
import org.slf4j.Logger;

public class LoggerHelper {
    public static void logCookies(Logger log, String prompt, Iterable<Cookie> cookies) {
        if (log.isDebugEnabled()) {
            if (cookies == null) {
                log.debug(prompt + ": null");
                return;
            }
            for (Cookie c : cookies) {
                log.debug(prompt + ": " + c.getName() + ": " + c.getValue());
            }
        }
    }

    public static void logHeaders(Logger log, String prompt, Header[] headers) {
        if (log.isDebugEnabled()) {
            if (headers == null) {
                log.debug(prompt + ": null");
                return;
            }
            for (Header h : headers) {
                log.debug(prompt + ": " + h.getName() + ": " + h.getValue());
            }
        }
    }

    public static void logHeaderDetails(Logger log, String prompt, Iterable<Header> headers) {
        if (log.isDebugEnabled()) {
            if (headers == null) {
                log.debug(prompt + ": null");
                return;
            }
            for (Header h : headers) {
                log.debug(prompt + " - HEADER: " + h.getName() + ": " + h.getValue());
                for (HeaderElement e : h.getElements()) {
                    log.debug(prompt + " -   ELEM: " + e.getName() + ": " + e.getValue());
                    for (NameValuePair p : e.getParameters()) {
                        log.debug(prompt + " -     P: " + p.getName() + ": " + p.getValue());
                    }
                }
            }
        }
    }
}

