/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeader;
import org.expath.httpclient.ContentType;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpConnection;
import org.expath.httpclient.HttpRequestBody;
import org.expath.httpclient.HttpResponseBody;
import org.expath.httpclient.impl.BinaryResponseBody;
import org.expath.httpclient.impl.HrefRequestBody;
import org.expath.httpclient.impl.MultipartRequestBody;
import org.expath.httpclient.impl.MultipartResponseBody;
import org.expath.httpclient.impl.SinglePartRequestBody;
import org.expath.httpclient.impl.TextResponseBody;
import org.expath.httpclient.impl.XmlResponseBody;
import org.expath.httpclient.model.Result;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;

public class BodyFactory {
    private static final Set<String> TEXT_TYPES = new HashSet<String>();
    private static final Set<String> XML_TYPES;

    public static HttpRequestBody makeRequestBody(Element elem, Sequence bodies, String ns) throws HttpClientException {
        Type method = BodyFactory.parseMethod(elem);
        if (method == null) {
            method = BodyFactory.parseType(elem);
        }
        switch (method) {
            case MULTIPART: {
                return new MultipartRequestBody(elem, bodies, ns);
            }
            case SRC: {
                return new HrefRequestBody(elem);
            }
            case XML: 
            case HTML: 
            case XHTML: 
            case TEXT: 
            case BINARY: 
            case HEX: 
            case BASE64: {
                return new SinglePartRequestBody(elem, bodies, method);
            }
        }
        throw new HttpClientException("could not happen");
    }

    public static HttpResponseBody makeResponseBody(Result result, ContentType type, HttpConnection conn) throws HttpClientException {
        if (type == null) {
            return null;
        }
        String t = type.getType();
        if (t == null) {
            return null;
        }
        InputStream in = conn.getResponseStream();
        if (in == null) {
            return null;
        }
        if (t.startsWith("multipart/")) {
            return new MultipartResponseBody(result, in, type);
        }
        return BodyFactory.makeResponsePart(result, null, in, type);
    }

    static HttpResponseBody makeResponsePart(Result result, HeaderSet headers, InputStream in, ContentType ctype) throws HttpClientException {
        switch (BodyFactory.parseType(ctype)) {
            case XML: {
                return new XmlResponseBody(result, in, ctype, headers, false);
            }
            case HTML: {
                return new XmlResponseBody(result, in, ctype, headers, true);
            }
            case TEXT: {
                return new TextResponseBody(result, in, ctype, headers);
            }
            case BINARY: {
                return new BinaryResponseBody(result, in, ctype, headers);
            }
        }
        throw new HttpClientException("INTERNAL ERROR: cannot happen");
    }

    private static Type parseType(String type) {
        if (type.startsWith("multipart/")) {
            return Type.MULTIPART;
        }
        if ("text/html".equals(type)) {
            return Type.HTML;
        }
        if (type.endsWith("+xml") || XML_TYPES.contains(type)) {
            return Type.XML;
        }
        if (type.startsWith("text/") || TEXT_TYPES.contains(type)) {
            return Type.TEXT;
        }
        return Type.BINARY;
    }

    public static Type parseType(HeaderSet headers) throws HttpClientException {
        Header h = headers.getFirstHeader("Content-Type");
        if (h == null) {
            throw new HttpClientException("impossible to find the content type");
        }
        ContentType ct = ContentType.parse(h, null, null);
        return BodyFactory.parseType(ct);
    }

    public static Type parseType(@Nullable ContentType type) throws HttpClientException {
        if (type == null) {
            throw new HttpClientException("impossible to find the content type");
        }
        String t = type.getType();
        if (t == null) {
            throw new HttpClientException("impossible to find the content type");
        }
        return BodyFactory.parseType(t);
    }

    private static Type parseType(Element elem) throws HttpClientException {
        String local = elem.getLocalName();
        if ("multipart".equals(local)) {
            return Type.MULTIPART;
        }
        if (!"body".equals(local)) {
            throw new HttpClientException("INTERNAL ERROR: cannot happen, checked before");
        }
        if (elem.getAttribute("src") != null) {
            return Type.SRC;
        }
        String mediaType = elem.getAttribute("media-type");
        if (mediaType == null) {
            throw new HttpClientException("@media-type is not set on http:body");
        }
        BasicHeader mediaTypeHeader = new BasicHeader("Media-Type", mediaType);
        HeaderElement[] mediaTypeHeaderElems = mediaTypeHeader.getElements();
        if (mediaTypeHeaderElems == null || mediaTypeHeaderElems.length == 0) {
            throw new HttpClientException("@media-type is not set on http:body");
        }
        if (mediaTypeHeaderElems.length > 1) {
            throw new HttpClientException("Multiple @media-type internet media types present");
        }
        Type type = BodyFactory.parseType(mediaTypeHeaderElems[0].getName());
        if (type == Type.MULTIPART) {
            String msg = "multipart type not allowed for http:body: " + mediaType;
            throw new HttpClientException(msg);
        }
        return type;
    }

    private static Type parseMethod(Element elem) throws HttpClientException {
        String m = elem.getAttribute("method");
        if (m == null) {
            return null;
        }
        if ("xml".equals(m)) {
            return Type.XML;
        }
        if ("html".equals(m)) {
            return Type.HTML;
        }
        if ("xhtml".equals(m)) {
            return Type.XHTML;
        }
        if ("text".equals(m)) {
            return Type.TEXT;
        }
        if ("binary".equals(m)) {
            return Type.BINARY;
        }
        if ("base64".equals(m)) {
            return Type.BASE64;
        }
        if ("hex".equals(m)) {
            return Type.HEX;
        }
        throw new HttpClientException("Incorrect value for @method: " + m);
    }

    static {
        TEXT_TYPES.add("application/x-www-form-urlencoded");
        TEXT_TYPES.add("application/xml-dtd");
        XML_TYPES = new HashSet<String>();
        XML_TYPES.add("text/xml");
        XML_TYPES.add("application/xml");
        XML_TYPES.add("text/xml-external-parsed-entity");
        XML_TYPES.add("application/xml-external-parsed-entity");
    }

    public static enum Type {
        XML,
        HTML,
        XHTML,
        TEXT,
        BINARY,
        BASE64,
        HEX,
        MULTIPART,
        SRC;

    }
}

