/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public class Version {
    private static final String VER_PROP = "version.properties";
    private static Version INSTANCE = null;
    private String myVersion;
    private String myRevision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Version() {
        InputStream rsrc = null;
        try {
            rsrc = this.getClass().getResourceAsStream(VER_PROP);
            if (rsrc == null) {
                throw new IllegalStateException("Version properties file does not exist: version.properties");
            }
            Properties props = new Properties();
            try {
                props.load(rsrc);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Error reading the version properties: version.properties", ex);
            }
            this.myVersion = props.getProperty("org.expath.httpclient.version");
            this.myRevision = props.getProperty("org.expath.httpclient.revision");
        }
        finally {
            if (rsrc != null) {
                try {
                    rsrc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        Version.instance().display(System.out);
    }

    public void display(PrintStream out) {
        out.println("EXPath HTTP Client for Java.");
        out.println("Version: " + this.getVersion() + " (revision #" + this.getRevision() + ")");
    }

    public static synchronized Version instance() {
        if (INSTANCE == null) {
            INSTANCE = new Version();
        }
        return INSTANCE;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getRevision() {
        return this.myRevision;
    }
}

