/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import javax.annotation.Nullable;
import org.apache.http.Header;
import org.expath.httpclient.ContentType;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpConnection;
import org.expath.httpclient.HttpCredentials;
import org.expath.httpclient.HttpRequest;
import org.expath.httpclient.HttpRequestBody;
import org.expath.httpclient.HttpResponse;
import org.expath.httpclient.HttpResponseBody;
import org.expath.httpclient.impl.BodyFactory;
import org.expath.httpclient.model.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestImpl
implements HttpRequest {
    private String myMethod;
    private String myHref;
    private String myHttpVer;
    private String myDefaultCharset;
    private String myOverrideType;
    private boolean myStatusOnly;
    private boolean myFollowRedirect = true;
    private Integer myTimeout = null;
    private boolean myGzip = false;
    private Boolean myChunked = null;
    private boolean myPreemptiveAuthentication = false;
    private HeaderSet myHeaders;
    private HttpRequestBody myBody;
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestImpl.class);

    @Override
    public HttpResponse send(Result result, HttpConnection conn, HttpCredentials cred) throws HttpClientException {
        long start = System.currentTimeMillis();
        if (this.myHeaders == null) {
            this.myHeaders = new HeaderSet();
        }
        conn.setRequestMethod(this.myMethod, this.myBody != null);
        conn.setRequestHeaders(this.myHeaders);
        if (this.myHttpVer != null) {
            conn.setHttpVersion(this.myHttpVer);
        }
        if (this.myTimeout != null) {
            conn.setTimeout(this.myTimeout);
        }
        if (this.myGzip) {
            conn.setGzip(true);
        }
        conn.setChunked(this.isChunked());
        conn.setPreemptiveAuthentication(this.isPreemptiveAuthentication());
        conn.setFollowRedirect(this.myFollowRedirect);
        conn.connect(this.myBody, cred);
        int status = conn.getResponseStatus();
        String msg = conn.getResponseMessage();
        HttpResponseBody body = null;
        if (!this.myStatusOnly) {
            ContentType type = this.getContentType(conn.getResponseHeaders());
            if (type == null) {
                LOG.debug("There is no Content-Type, we assume there is no content");
            } else {
                body = BodyFactory.makeResponseBody(result, type, conn);
            }
        }
        long stop = System.currentTimeMillis();
        long spent = stop - start;
        HttpResponse resp = new HttpResponse(status, msg, conn.getResponseHeaders(), body, spent);
        result.add(resp);
        return resp;
    }

    @Nullable
    private ContentType getContentType(HeaderSet headers) throws HttpClientException {
        Header header = headers.getFirstHeader("Content-Type");
        return ContentType.parse(header, this.myOverrideType, this.myDefaultCharset);
    }

    @Override
    public String getMethod() {
        return this.myMethod;
    }

    @Override
    public void setMethod(String method) {
        this.myMethod = method;
    }

    @Override
    public String getHref() {
        return this.myHref;
    }

    @Override
    public void setHref(String href) {
        this.myHref = href;
    }

    @Override
    public String getHttpVersion() {
        return this.myHttpVer;
    }

    @Override
    public void setHttpVersion(String ver) throws HttpClientException {
        if ("1.0".equals(ver)) {
            this.myHttpVer = "1.0";
        } else if ("1.1".equals(ver)) {
            this.myHttpVer = "1.1";
        } else {
            throw new HttpClientException("Unknown HTTP version: '" + ver + "'");
        }
    }

    @Override
    public void setDefaultCharset(String charset) {
        this.myDefaultCharset = charset;
    }

    @Override
    public void setOverrideType(String type) {
        this.myOverrideType = type;
    }

    @Override
    public void setHeaders(HeaderSet headers) {
        this.myHeaders = headers;
    }

    @Override
    public void setBody(HttpRequestBody body) throws HttpClientException {
        this.myBody = body;
        body.setHeaders(this.myHeaders);
    }

    @Override
    public void setStatusOnly(boolean only) {
        this.myStatusOnly = only;
    }

    @Override
    public void setFollowRedirect(boolean follow) {
        this.myFollowRedirect = follow;
    }

    @Override
    public void setTimeout(Integer seconds) {
        this.myTimeout = seconds;
    }

    @Override
    public void setGzip(boolean gzip) {
        this.myGzip = gzip;
    }

    @Override
    public boolean isChunked() {
        if (this.myChunked == null) {
            return this.myHttpVer == null || !this.myHttpVer.equals("1.0");
        }
        return this.myChunked;
    }

    @Override
    public void setChunked(boolean chunked) {
        this.myChunked = chunked;
    }

    @Override
    public boolean isPreemptiveAuthentication() {
        return this.myPreemptiveAuthentication;
    }

    @Override
    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.myPreemptiveAuthentication = preemptiveAuthentication;
    }
}

