/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.impl;

import java.io.InputStream;
import org.expath.httpclient.ContentType;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpResponseBody;
import org.expath.httpclient.model.Result;
import org.expath.httpclient.model.TreeBuilder;
import org.expath.tools.ToolsException;

public class BinaryResponseBody
implements HttpResponseBody {
    private ContentType myContentType;
    private HeaderSet myHeaders;

    public BinaryResponseBody(Result result, InputStream in, ContentType type, HeaderSet headers) throws HttpClientException {
        this.myContentType = type;
        this.myHeaders = headers;
        result.add(in);
    }

    @Override
    public void outputBody(TreeBuilder b) throws HttpClientException {
        if (this.myHeaders != null) {
            b.outputHeaders(this.myHeaders);
        }
        try {
            b.startElem("body");
            b.attribute("media-type", this.myContentType.getValue());
            b.startContent();
            b.endElem();
        }
        catch (ToolsException ex) {
            throw new HttpClientException("Error building the body", ex);
        }
    }
}

