/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.expath.httpclient.HttpClientException;

public class HeaderSet
implements Iterable<Header> {
    private List<Header> myHeaders;

    public HeaderSet() {
        this.myHeaders = new ArrayList<Header>();
    }

    public HeaderSet(Header[] headers) throws HttpClientException {
        if (headers == null) {
            throw new HttpClientException("Headers array is null");
        }
        this.myHeaders = new ArrayList<Header>(headers.length);
        this.myHeaders.addAll(Arrays.asList(headers));
    }

    public HeaderSet(Collection<Header> headers) throws HttpClientException {
        if (headers == null) {
            throw new HttpClientException("Headers list is null");
        }
        this.myHeaders = new ArrayList<Header>(headers);
    }

    @Override
    public Iterator<Header> iterator() {
        return this.myHeaders.iterator();
    }

    public Header[] toArray() {
        return this.myHeaders.toArray(new Header[0]);
    }

    public boolean isEmpty() {
        return this.myHeaders.isEmpty();
    }

    public Header add(Header h) {
        this.myHeaders.add(h);
        return h;
    }

    public Header add(String name, String value) {
        BasicHeader h = new BasicHeader(name, value);
        this.myHeaders.add((Header)h);
        return h;
    }

    public Header getFirstHeader(String name) throws HttpClientException {
        for (Header h : this.myHeaders) {
            if (!name.equalsIgnoreCase(h.getName())) continue;
            return h;
        }
        return null;
    }
}

