/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient;

import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.expath.httpclient.HttpClientException;

public class ContentType {
    private final String myType;
    private final String myCharset;
    private final String myBoundary;

    public ContentType(String type, String charset, String boundary) {
        this.myType = type;
        this.myCharset = charset;
        this.myBoundary = boundary;
    }

    @Nullable
    public static ContentType parse(@Nullable Header header, @Nullable String overrideType, @Nullable String defaultCharset) throws HttpClientException {
        String boundary;
        String charset;
        String type;
        if (overrideType != null) {
            HeaderElement[] headerElements;
            type = ContentType.extractMediaTypeFromContentType(overrideType);
            if (overrideType.indexOf("charset=") > -1) {
                charset = overrideType.replaceFirst(".+charset=([^;\\s]+).*", "$1");
            } else {
                if (header == null || !"Content-Type".equalsIgnoreCase(header.getName())) {
                    throw new HttpClientException("Header is not content type");
                }
                headerElements = header.getElements();
                if (headerElements.length > 1) {
                    throw new HttpClientException("Multiple Content-Type headers");
                }
                NameValuePair headerCharset = headerElements[0].getParameterByName("charset");
                charset = headerCharset != null ? headerCharset.getValue() : defaultCharset;
            }
            if (overrideType.indexOf("boundary=") > -1) {
                boundary = overrideType.replaceFirst(".+boundary=([^;\\s]+).*", "$1");
            } else {
                if (header == null || !"Content-Type".equalsIgnoreCase(header.getName())) {
                    throw new HttpClientException("Header is not content type");
                }
                headerElements = header.getElements();
                if (headerElements.length > 1) {
                    throw new HttpClientException("Multiple Content-Type headers");
                }
                NameValuePair headerBoundary = headerElements[0].getParameterByName("boundary");
                boundary = headerBoundary == null ? null : headerBoundary.getValue();
            }
        } else {
            if (header == null) {
                return null;
            }
            if (!"Content-Type".equalsIgnoreCase(header.getName())) {
                throw new HttpClientException("Header is not Content-Type");
            }
            HeaderElement[] headerElements = header.getElements();
            if (headerElements.length > 1) {
                throw new HttpClientException("Multiple Content-Type headers");
            }
            type = ContentType.extractMediaTypeFromContentType(header.getValue());
            NameValuePair headerCharset = headerElements[0].getParameterByName("charset");
            charset = headerCharset != null ? headerCharset.getValue() : defaultCharset;
            NameValuePair headerBoundary = headerElements[0].getParameterByName("boundary");
            boundary = headerBoundary == null ? null : headerBoundary.getValue();
        }
        return new ContentType(type, charset, boundary);
    }

    private static String extractMediaTypeFromContentType(String contentType) {
        int idxParamSeparator = contentType.indexOf(59);
        if (idxParamSeparator > -1) {
            return contentType.substring(0, idxParamSeparator);
        }
        return contentType;
    }

    @Nullable
    public String getType() {
        return this.myType;
    }

    @Nullable
    public String getCharset() {
        return this.myCharset;
    }

    @Nullable
    public String getBoundary() {
        return this.myBoundary;
    }

    @Nullable
    public String getValue() {
        StringBuilder builder = new StringBuilder(this.myType);
        if (this.myCharset != null) {
            builder.append("; charset=").append(this.myCharset);
        }
        if (this.myBoundary != null) {
            builder.append("; boundary=").append(this.myCharset);
        }
        return builder.toString();
    }

    public String toString() {
        return this.getValue();
    }
}

