/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.masterservice;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.ActorSystem;
import org.elasticsoftware.elasticactors.MethodActor;
import org.elasticsoftware.elasticactors.PhysicalNode;
import org.elasticsoftware.elasticactors.ServiceActor;
import org.elasticsoftware.elasticactors.cluster.ClusterEventListener;
import org.elasticsoftware.elasticactors.cluster.ClusterService;
import org.elasticsoftware.elasticactors.masterservice.messages.MasterElected;

public abstract class MasterService
extends MethodActor
implements ClusterEventListener {
    private final AtomicReference<MasterElected> pendingMasterElected = new AtomicReference<Object>(null);
    private final AtomicBoolean activated = new AtomicBoolean(false);
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private final ActorSystem actorSystem;
    private final ClusterService clusterService;
    private final ActorRef self;
    private ActorRef masterRef;

    protected MasterService(ActorSystem actorSystem, ClusterService clusterService) {
        this.actorSystem = actorSystem;
        this.clusterService = clusterService;
        ServiceActor serviceActor = ((Object)((Object)this)).getClass().getAnnotation(ServiceActor.class);
        if (serviceActor == null) {
            throw new IllegalArgumentException("This class needs to be inherited by a concrete class annotated with @ServiceActor");
        }
        this.self = actorSystem.serviceActorFor(serviceActor.value());
        this.clusterService.addEventListener((ClusterEventListener)this);
    }

    private String getServiceActorName() {
        ServiceActor serviceActor = ((Object)((Object)this)).getClass().getAnnotation(ServiceActor.class);
        return serviceActor != null ? serviceActor.value() : null;
    }

    public final void postActivate(String previousVersion) throws Exception {
        MasterElected masterElected;
        this.doActivate(previousVersion);
        if (this.activated.compareAndSet(false, true) && (masterElected = (MasterElected)this.pendingMasterElected.getAndSet(null)) != null) {
            this.getSelf().tell((Object)masterElected, this.getSelf());
        }
    }

    protected abstract void doActivate(String var1) throws Exception;

    public final void onTopologyChanged(List<PhysicalNode> topology) throws Exception {
    }

    public final void onMasterElected(PhysicalNode masterNode) throws Exception {
        this.logger.info((Object)String.format("New Master Elected: %s", masterNode.toString()));
        if (!this.activated.get()) {
            this.pendingMasterElected.set(new MasterElected(masterNode.getId(), masterNode.isLocal()));
        } else {
            this.self.tell((Object)new MasterElected(masterNode.getId(), masterNode.isLocal()), this.self);
        }
    }

    public final void onReceive(ActorRef sender, Object message) throws Exception {
        if (message instanceof MasterElected) {
            this.handleMasterElected((MasterElected)message);
        } else if (this.masterRef != null && !this.masterRef.equals(this.self)) {
            this.masterRef.tell(message, sender);
        } else {
            super.onReceive(sender, message);
        }
    }

    private final void handleMasterElected(MasterElected masterElected) throws Exception {
        this.masterRef = this.actorSystem.serviceActorFor(masterElected.getId(), this.getServiceActorName());
        this.onMasterElected(masterElected.isLocal());
    }

    protected abstract void onMasterElected(boolean var1) throws Exception;
}

