/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.rest.jvm;

import io.vertx.core.AsyncResult;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.dominokit.rest.VertxInstanceProvider;
import org.dominokit.rest.jvm.JavaResponse;
import org.dominokit.rest.shared.BaseRestfulRequest;
import org.dominokit.rest.shared.GwtIncompatible;
import org.dominokit.rest.shared.Response;
import org.dominokit.rest.shared.RestfulRequest;

@GwtIncompatible
public class JavaRestfulRequest
extends BaseRestfulRequest {
    private final HttpRequest<Buffer> request;
    private WebClient webClient;

    public JavaRestfulRequest(String uri, String method) {
        super(uri, method);
        this.request = this.getWebClient().requestAbs(HttpMethod.valueOf((String)method), uri);
    }

    protected String paramsAsString() {
        return this.request.queryParams().entries().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
    }

    public JavaRestfulRequest addQueryParam(String key, String value) {
        this.request.addQueryParam(key, value);
        return this;
    }

    public JavaRestfulRequest setQueryParam(String key, String value) {
        this.request.setQueryParam(key, value);
        return this;
    }

    public JavaRestfulRequest putHeader(String key, String value) {
        this.request.putHeader(key, value);
        return this;
    }

    public RestfulRequest putHeaders(Map<String, String> headers) {
        if (Objects.nonNull(headers)) {
            headers.forEach(this::putHeader);
        }
        return this;
    }

    public RestfulRequest putParameters(Map<String, String> parameters) {
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            parameters.forEach(this::addQueryParam);
        }
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.request.headers().entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public RestfulRequest timeout(int timeout) {
        this.request.timeout((long)timeout);
        return super.timeout(timeout);
    }

    public void sendForm(Map<String, String> formData) {
        this.request.sendForm(MultiMap.caseInsensitiveMultiMap().addAll(formData), this::handleResponse);
    }

    public void sendJson(String json) {
        this.putHeader("Content-Type", "application/json");
        this.send(json);
    }

    public void send(String data) {
        this.request.sendBuffer(Buffer.buffer((String)data), this::handleResponse);
    }

    public void send() {
        this.request.send(this::handleResponse);
    }

    public void abort() {
    }

    public void setWithCredentials(boolean withCredentials) {
    }

    private void handleResponse(AsyncResult<HttpResponse<Buffer>> event) {
        if (event.succeeded()) {
            this.successHandler.onResponseReceived((Response)new JavaResponse((HttpResponse<Buffer>)((HttpResponse)event.result())));
        } else {
            this.errorHandler.onError(event.cause());
        }
    }

    public RestfulRequest setResponseType(String responseType) {
        return this;
    }

    private WebClient getWebClient() {
        if (Objects.isNull(this.webClient)) {
            Iterator<VertxInstanceProvider> iterator = ServiceLoader.load(VertxInstanceProvider.class).iterator();
            Vertx instance = iterator.hasNext() ? iterator.next().getInstance() : Vertx.vertx();
            this.webClient = WebClient.create((Vertx)instance);
        }
        return this.webClient;
    }
}

