/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.rest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dominokit.jackson.JacksonContextProvider;
import org.dominokit.rest.JavaRestfulRequestFactory;
import org.dominokit.rest.RestfulRequestFactory;
import org.dominokit.rest.RestfullRequestContext;
import org.dominokit.rest.jvm.DefaultServiceRoot;
import org.dominokit.rest.jvm.OnServerRequestEventFactory;
import org.dominokit.rest.shared.request.AsyncRunner;
import org.dominokit.rest.shared.request.DefaultRequestAsyncSender;
import org.dominokit.rest.shared.request.DominoRestContext;
import org.dominokit.rest.shared.request.DynamicServiceRoot;
import org.dominokit.rest.shared.request.Fail;
import org.dominokit.rest.shared.request.RequestAsyncSender;
import org.dominokit.rest.shared.request.RequestInterceptor;
import org.dominokit.rest.shared.request.RequestRestSender;
import org.dominokit.rest.shared.request.RequestRouter;
import org.dominokit.rest.shared.request.RequestSender;
import org.dominokit.rest.shared.request.ResponseInterceptor;
import org.dominokit.rest.shared.request.RestConfig;
import org.dominokit.rest.shared.request.ServerRequest;
import org.dominokit.rest.shared.request.ServerRequestEventFactory;
import org.dominokit.rest.shared.request.ServerRouter;

public class DominoRestConfig
implements RestConfig {
    private static final Logger LOGGER = Logger.getLogger(DominoRestConfig.class.getName());
    private static String defaultServiceRoot;
    private static String defaultResourceRootPath;
    private static String defaultJsonDateFormat;
    private static RequestRouter<ServerRequest> serverRouter;
    private static List<DynamicServiceRoot> dynamicServiceRoots;
    private static List<RequestInterceptor> requestInterceptors;
    private static final List<ResponseInterceptor> responseInterceptors;
    private static Fail defaultFailHandler;
    private static RestConfig.DateParamFormatter dateParamFormatter;

    public static DominoRestConfig initDefaults() {
        RestfullRequestContext.setFactory((RestfulRequestFactory)new JavaRestfulRequestFactory());
        DominoRestContext.init((RestConfig)DominoRestConfig.getInstance());
        return DominoRestConfig.getInstance();
    }

    public static DominoRestConfig getInstance() {
        return new DominoRestConfig();
    }

    public DominoRestConfig setDefaultServiceRoot(String defaultServiceRoot) {
        DominoRestConfig.defaultServiceRoot = defaultServiceRoot;
        return this;
    }

    public DominoRestConfig setDefaultJsonDateFormat(String defaultJsonDateFormat) {
        JacksonContextProvider.get().defaultDeserializerParameters().setPattern(defaultJsonDateFormat);
        return this;
    }

    public DominoRestConfig addDynamicServiceRoot(DynamicServiceRoot dynamicServiceRoot) {
        dynamicServiceRoots.add(dynamicServiceRoot);
        return this;
    }

    public DominoRestConfig addRequestInterceptor(RequestInterceptor interceptor) {
        requestInterceptors.add(interceptor);
        return this;
    }

    public DominoRestConfig removeRequestInterceptor(RequestInterceptor interceptor) {
        requestInterceptors.remove(interceptor);
        return this;
    }

    public List<RequestInterceptor> getRequestInterceptors() {
        return requestInterceptors;
    }

    public DominoRestConfig addResponseInterceptor(ResponseInterceptor responseInterceptor) {
        this.getResponseInterceptors().add(responseInterceptor);
        return this;
    }

    public DominoRestConfig removeResponseInterceptor(ResponseInterceptor responseInterceptor) {
        this.getResponseInterceptors().remove(responseInterceptor);
        return this;
    }

    public List<ResponseInterceptor> getResponseInterceptors() {
        return responseInterceptors;
    }

    public DominoRestConfig setDefaultFailHandler(Fail fail) {
        if (Objects.nonNull(fail)) {
            defaultFailHandler = fail;
        }
        return this;
    }

    public Fail getDefaultFailHandler() {
        return defaultFailHandler;
    }

    public String getDefaultServiceRoot() {
        if (Objects.isNull(defaultServiceRoot)) {
            return DefaultServiceRoot.get() + defaultResourceRootPath + "/";
        }
        return defaultServiceRoot;
    }

    public String getDefaultJsonDateFormat() {
        return JacksonContextProvider.get().defaultDeserializerParameters().getPattern();
    }

    public List<DynamicServiceRoot> getServiceRoots() {
        return dynamicServiceRoots;
    }

    public DominoRestConfig setDefaultResourceRootPath(String rootPath) {
        if (Objects.nonNull(rootPath)) {
            defaultResourceRootPath = rootPath;
        }
        return this;
    }

    public RequestRouter<ServerRequest> getServerRouter() {
        return serverRouter;
    }

    public String getDefaultResourceRootPath() {
        if (Objects.nonNull(defaultResourceRootPath) && !defaultResourceRootPath.trim().isEmpty()) {
            return defaultResourceRootPath + "/";
        }
        return "";
    }

    public AsyncRunner asyncRunner() {
        return asyncTask -> {
            try {
                asyncTask.onSuccess();
            }
            catch (Throwable error) {
                asyncTask.onFailed(error);
            }
        };
    }

    public void setServerRouter(RequestRouter<ServerRequest> serverRouter) {
        DominoRestConfig.serverRouter = serverRouter;
    }

    public RestConfig setDateParamFormatter(RestConfig.DateParamFormatter formatter) {
        dateParamFormatter = formatter;
        return this;
    }

    public RestConfig.DateParamFormatter getDateParamFormatter() {
        return dateParamFormatter;
    }

    static {
        defaultResourceRootPath = "service";
        defaultJsonDateFormat = null;
        serverRouter = new ServerRouter((RequestAsyncSender)new DefaultRequestAsyncSender((ServerRequestEventFactory)new OnServerRequestEventFactory(), (RequestRestSender)new RequestSender()));
        dynamicServiceRoots = new ArrayList<DynamicServiceRoot>();
        requestInterceptors = new ArrayList<RequestInterceptor>();
        responseInterceptors = new ArrayList<ResponseInterceptor>();
        defaultFailHandler = failedResponse -> {
            if (Objects.nonNull(failedResponse.getThrowable())) {
                LOGGER.log(Level.FINE, "could not execute request on server: ", failedResponse.getThrowable());
            } else {
                LOGGER.log(Level.FINE, "could not execute request on server: status [" + failedResponse.getStatusCode() + "], body [" + failedResponse.getBody() + "]");
            }
        };
        dateParamFormatter = (date, pattern) -> new SimpleDateFormat(pattern).format(date);
    }
}

