/*
 * Decompiled with CFR 0.152.
 */
package org.doktorodata.ohdata.connectivity;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Properties;
import org.apache.cxf.common.util.Base64Utility;
import org.doktorodata.ohdata.client.exceptions.ConnectionFactoryException;
import org.doktorodata.ohdata.connectivity.ConnectionFactory;
import org.doktorodata.ohdata.util.StreamAndStringTools;
import org.json.JSONObject;

public class DirectHTTPConnectionFactory
extends ConnectionFactory {
    private Properties prop;
    private String currentToken;
    private Date currentTokenLifetime;

    public DirectHTTPConnectionFactory(String destname) throws ConnectionFactoryException {
        try {
            this.prop = new Properties();
            File f = new File(destname);
            FileInputStream fis = new FileInputStream(f);
            this.prop.load(fis);
            fis.close();
            String proxyhost = this.prop.getProperty("proxyhost");
            String proxyport = this.prop.getProperty("proxyport");
            if (proxyhost != null && proxyport != null) {
                System.setProperty("http.proxyHost", proxyhost);
                System.setProperty("https.proxyHost", proxyhost);
                System.setProperty("http.proxyPort", proxyport);
                System.setProperty("https.proxyPort", proxyport);
            }
        }
        catch (IOException e) {
            throw new ConnectionFactoryException(e);
        }
    }

    @Override
    public URLConnection getConnection(String path) throws ConnectionFactoryException {
        try {
            String baseURL = this.prop.getProperty("URL");
            String fullURL = baseURL + "/" + path;
            URL url = new URL(fullURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            String authType = this.prop.getProperty("Authentication");
            if (authType.equals("BasicAuthentication")) {
                String user = this.prop.getProperty("User");
                String pass = this.prop.getProperty("Password");
                String encoded = Base64Utility.encode((byte[])(user + ":" + pass).getBytes());
                conn.setRequestProperty("Authorization", "Basic " + encoded);
            } else if (authType.equals("oAuthToken")) {
                String bearer = this.prop.getProperty("Password");
                conn.setRequestProperty("Authorization", "Bearer " + bearer);
            } else if (authType.equals("oAuth")) {
                conn.setRequestProperty("Authorization", "Bearer " + this.retrieveValidBearerToken());
            }
            return conn;
        }
        catch (FileNotFoundException e) {
            throw new ConnectionFactoryException(e);
        }
        catch (MalformedURLException e) {
            throw new ConnectionFactoryException(e);
        }
        catch (IOException e) {
            throw new ConnectionFactoryException(e);
        }
    }

    private String retrieveValidBearerToken() throws ConnectionFactoryException {
        try {
            if (this.currentToken != null && (this.currentTokenLifetime == null || new Date().after(this.currentTokenLifetime))) {
                return this.currentToken;
            }
            String oauthurl = this.prop.getProperty("oAuthURL");
            String clientid = this.prop.getProperty("User");
            String secret = this.prop.getProperty("Password");
            String scope = this.prop.getProperty("Scope");
            HttpURLConnection oAuthConn = (HttpURLConnection)new URL(oauthurl).openConnection();
            oAuthConn.setRequestMethod("POST");
            oAuthConn.setDoOutput(true);
            String encoded = Base64Utility.encode((byte[])(clientid + ":" + secret).getBytes());
            oAuthConn.setRequestProperty("Authorization", "Basic " + encoded);
            oAuthConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            oAuthConn.connect();
            OutputStream os = oAuthConn.getOutputStream();
            String bodyContent = "grant_type=client_credentials";
            if (scope != null && !scope.equals("")) {
                bodyContent = bodyContent + "&scope=" + scope;
            }
            StreamAndStringTools.write(bodyContent, os, "UTF-8");
            os.close();
            InputStream is = oAuthConn.getInputStream();
            String content = StreamAndStringTools.toString(is, "UTF-8");
            JSONObject json = new JSONObject(content);
            is.close();
            this.currentToken = json.getString("access_token");
            int lifetime = json.getInt("expires_in");
            this.currentTokenLifetime = new Date(new Date().getTime() + (long)(lifetime * 1000) - 60000L);
            return this.currentToken;
        }
        catch (IOException e) {
            throw new ConnectionFactoryException(e);
        }
    }
}

