/*
 * Decompiled with CFR 0.152.
 */
package org.doktorodata.ohdata.client.base;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;

public class OhQuery {
    private int skip = 0;
    private int top = -1;
    private String orderbyString = "";
    private String expandString = "";
    ArrayList<String> filters = new ArrayList();
    private boolean lastFilterDelimited = true;

    public OhQuery skip(int skip) {
        this.skip = skip;
        return this;
    }

    public OhQuery top(int top) {
        this.top = top;
        return this;
    }

    public OhQuery orderby(String field) {
        if (!this.orderbyString.equals("")) {
            this.orderbyString = this.orderbyString + ",";
        }
        this.orderbyString = this.orderbyString + field;
        return this;
    }

    public OhQuery expand(String association) {
        if (!this.expandString.equals("")) {
            this.expandString = this.expandString + ",";
        }
        this.expandString = this.expandString + association;
        return this;
    }

    public OhQuery filter(String field, String operator, String value) {
        this.checkFilterDelimition();
        String filter = field + " " + operator + " '" + value + "'";
        this.filters.add(filter);
        return this;
    }

    public OhQuery filter(String field, String operator, int value) {
        this.checkFilterDelimition();
        String filter = field + " " + operator + " " + value;
        this.filters.add(filter);
        return this;
    }

    public OhQuery filter(String field, String operator, float value) {
        this.checkFilterDelimition();
        String filter = field + " " + operator + " " + value;
        this.filters.add(filter);
        return this;
    }

    public OhQuery filter(String field, String operator, double value) {
        this.checkFilterDelimition();
        String filter = field + " " + operator + " " + value;
        this.filters.add(filter);
        return this;
    }

    public OhQuery filter(String field, String operator, BigDecimal value) {
        this.checkFilterDelimition();
        String filter = field + " " + operator + " " + value;
        this.filters.add(filter);
        return this;
    }

    public OhQuery filter(String field, String operator, Short value) {
        this.checkFilterDelimition();
        String filter = field + " " + operator + " " + value;
        this.filters.add(filter);
        return this;
    }

    public OhQuery filter(String field, String operator, Date time) {
        this.checkFilterDelimition();
        String timeToEDM = String.format("%1$tFT%1$tT", time);
        String filter = field + " " + operator + " datetime'" + timeToEDM + "'";
        this.filters.add(filter);
        return this;
    }

    private void checkFilterDelimition() {
        if (!this.lastFilterDelimited) {
            this.and();
        }
        this.lastFilterDelimited = false;
    }

    public OhQuery openSub() {
        this.checkFilterDelimition();
        this.filters.add("(");
        return this;
    }

    public OhQuery closeSub() {
        this.checkFilterDelimition();
        this.filters.add(")");
        return this;
    }

    public OhQuery and() {
        this.lastFilterDelimited = true;
        this.filters.add(" and ");
        return this;
    }

    public OhQuery or() {
        this.lastFilterDelimited = true;
        this.filters.add(" or ");
        return this;
    }

    public String generateParameterString() {
        String parameterString = "";
        if (this.filters.size() > 0) {
            String filterString = "";
            filterString = filterString + "(";
            for (String filter : this.filters) {
                filterString = filterString + filter;
            }
            filterString = filterString + ")";
            parameterString = this.addParameter(parameterString, "$filter", filterString);
        }
        if (!this.expandString.equals("")) {
            parameterString = this.addParameter(parameterString, "$expand", this.expandString);
        }
        if (!this.orderbyString.equals("")) {
            parameterString = this.addParameter(parameterString, "$orderby", this.orderbyString);
        }
        if (this.top > 0) {
            parameterString = this.addParameter(parameterString, "$top", new Integer(this.top).toString());
        }
        if (this.skip > 0) {
            parameterString = this.addParameter(parameterString, "$skip", new Integer(this.skip).toString());
        }
        return parameterString;
    }

    private String addParameter(String parameterString, String field, String value) {
        try {
            parameterString = parameterString + field + "=" + URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (!parameterString.equals("")) {
            parameterString = parameterString + "&";
        }
        return parameterString;
    }
}

