/*
 * Decompiled with CFR 0.152.
 */
package org.doktorodata.ohdata.client.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.doktorodata.ohdata.client.base.OhQuery;
import org.doktorodata.ohdata.client.base.OhResult;
import org.doktorodata.ohdata.client.exceptions.ConnectionFactoryException;
import org.doktorodata.ohdata.client.exceptions.OhDataCallException;
import org.doktorodata.ohdata.connectivity.ConnectionFactory;
import org.doktorodata.ohdata.util.StreamAndStringTools;
import org.json.JSONObject;

public class OhCaller {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static String contentTypeToBeUsed = "application/json";
    private static final String SEPARATOR = "/";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE_VALUE_DELIMITER = ";";
    private static final String SET_COOKIE_SEPARATOR = "; ";
    private static final String COOKIE = "Cookie";
    private static final char NAME_VALUE_SEPARATOR = '=';
    private ConnectionFactory cf;
    private String urlPath;
    private Edm edm;
    private CookieManager cookieMan;

    public OhCaller(ConnectionFactory cf, String urlPath) {
        this.cf = cf;
        this.urlPath = urlPath;
        this.cookieMan = new CookieManager();
    }

    public Edm readEdm() throws OhDataCallException {
        try {
            if (this.edm == null) {
                String content = this.executeGET(this.urlPath + "/$metadata", APPLICATION_XML);
                InputStream is = StreamAndStringTools.toInputStream(content, "UTF-8");
                this.edm = EntityProvider.readMetadata((InputStream)is, (boolean)false);
            }
            return this.edm;
        }
        catch (ODataException e) {
            throw new OhDataCallException((Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new OhDataCallException(e);
        }
    }

    public void setCookies(URLConnection conn) throws URISyntaxException {
        StringBuffer cookieStringBuffer = new StringBuffer();
        List<HttpCookie> cookies = this.cookieMan.getCookieStore().get(conn.getURL().toURI());
        for (HttpCookie cookie : cookies) {
            String cookieName = cookie.getName();
            String value = cookie.getValue();
            cookieStringBuffer.append(cookieName);
            cookieStringBuffer.append('=');
            cookieStringBuffer.append(value);
            cookieStringBuffer.append(SET_COOKIE_SEPARATOR);
        }
        conn.setRequestProperty(COOKIE, cookieStringBuffer.toString());
    }

    public void getAndStoreCookies(URLConnection conn) throws URISyntaxException {
        String headerName = null;
        int i = 1;
        while ((headerName = conn.getHeaderFieldKey(i)) != null) {
            if (headerName.equalsIgnoreCase(SET_COOKIE)) {
                String tokenString = conn.getHeaderField(i);
                StringTokenizer st = new StringTokenizer(tokenString, COOKIE_VALUE_DELIMITER);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.contains("=")) continue;
                    String name = token.substring(0, token.indexOf(61));
                    String value = token.substring(token.indexOf(61) + 1, token.length());
                    this.cookieMan.getCookieStore().add(conn.getURL().toURI(), new HttpCookie(name, value));
                }
            }
            ++i;
        }
    }

    public OhResult readFeed(String entitySetName, OhQuery query) throws OhDataCallException {
        try {
            Edm edm = this.readEdm();
            EdmEntityContainer entityContainer = edm.getDefaultEntityContainer();
            String serviceUri = this.urlPath;
            String absolutUri = this.createUri(serviceUri, entitySetName, null, query);
            HttpURLConnection connection = (HttpURLConnection)this.cf.getConnection(absolutUri);
            connection.setRequestMethod(HTTP_METHOD_GET);
            connection.setRequestProperty("Accept", contentTypeToBeUsed);
            this.setCookies(connection);
            connection.connect();
            HttpStatusCodes statusCode = HttpStatusCodes.fromStatusCode((int)connection.getResponseCode());
            if (statusCode == HttpStatusCodes.OK) {
                InputStream is = connection.getInputStream();
                this.getAndStoreCookies(connection);
                ODataFeed feed = EntityProvider.readFeed((String)contentTypeToBeUsed, (EdmEntitySet)entityContainer.getEntitySet(entitySetName), (InputStream)is, (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
                is.close();
                connection.disconnect();
                return new OhResult(true, 10, feed);
            }
            if (statusCode == HttpStatusCodes.NOT_FOUND) {
                connection.disconnect();
                return new OhResult(false, 1);
            }
            throw this.handleConnectionError(connection, "HTTP Error Code " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        catch (IOException | URISyntaxException | EdmException | EntityProviderException | ConnectionFactoryException e) {
            throw new OhDataCallException((Exception)e);
        }
    }

    public OhResult readEntry(String entitySetName, Object keyValue) throws OhDataCallException {
        return this.readEntry(entitySetName, keyValue, null);
    }

    public OhResult readEntry(String entitySetName, Object keyValue, OhQuery query) throws OhDataCallException {
        try {
            Edm edm = this.readEdm();
            String serviceUri = this.urlPath;
            EdmEntityContainer entityContainer = edm.getDefaultEntityContainer();
            String absolutUri = this.createUri(serviceUri, entitySetName, keyValue, query);
            HttpURLConnection connection = (HttpURLConnection)this.cf.getConnection(absolutUri);
            connection.setRequestMethod(HTTP_METHOD_GET);
            connection.setRequestProperty("Accept", contentTypeToBeUsed);
            this.setCookies(connection);
            connection.connect();
            HttpStatusCodes statusCode = HttpStatusCodes.fromStatusCode((int)connection.getResponseCode());
            if (statusCode == HttpStatusCodes.OK) {
                this.getAndStoreCookies(connection);
                InputStream is = connection.getInputStream();
                ODataEntry entry = EntityProvider.readEntry((String)contentTypeToBeUsed, (EdmEntitySet)entityContainer.getEntitySet(entitySetName), (InputStream)is, (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
                is.close();
                connection.disconnect();
                return new OhResult(true, 10, entry);
            }
            if (statusCode == HttpStatusCodes.NOT_FOUND) {
                connection.disconnect();
                return new OhResult(false, 1);
            }
            throw this.handleConnectionError(connection, "HTTP Error Code " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        catch (IOException | URISyntaxException | EdmException | EntityProviderException | ConnectionFactoryException e) {
            throw new OhDataCallException((Exception)e);
        }
    }

    public OhResult createEntry(String entitySetName, JSONObject json) throws OhDataCallException {
        try {
            Edm edm = this.readEdm();
            String serviceUri = this.urlPath;
            String absolutUri = this.createUri(serviceUri, entitySetName, null);
            String contentType = APPLICATION_JSON;
            HttpURLConnection connection = (HttpURLConnection)this.cf.getConnection(absolutUri);
            connection.setRequestMethod(HTTP_METHOD_POST);
            String csrfToken = this.getCSRFToken(absolutUri);
            if (csrfToken != null) {
                connection.addRequestProperty("x-csrf-token", csrfToken);
            }
            connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
            connection.setRequestProperty("Accept", contentType);
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("DataServiceVersion", "2.0");
            connection.setRequestProperty("X-Requested-With", "XMLHttpRequest");
            connection.setRequestProperty("X-Requested-With", "XMLHttpRequest");
            this.setCookies(connection);
            EdmEntityContainer entityContainer = edm.getDefaultEntityContainer();
            EdmEntitySet entitySet = entityContainer.getEntitySet(entitySetName);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Length", new Integer(json.toString().getBytes().length).toString());
            OutputStream os = connection.getOutputStream();
            StreamAndStringTools.write(json.toString(), os, "UTF-8");
            os.flush();
            connection.connect();
            ODataEntry entry = null;
            HttpStatusCodes statusCode = HttpStatusCodes.fromStatusCode((int)connection.getResponseCode());
            if (statusCode == HttpStatusCodes.CREATED) {
                this.getAndStoreCookies(connection);
                InputStream content = connection.getInputStream();
                String contentStr = StreamAndStringTools.toString(content, "UTF-8");
                InputStream content2 = StreamAndStringTools.toInputStream(contentStr, "UTF-8");
                entry = EntityProvider.readEntry((String)contentType, (EdmEntitySet)entitySet, (InputStream)content2, (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
                return new OhResult(true, 20, entry);
            }
            String errorText = this.getErrornousConnectionMessage(connection);
            if (errorText.contains("Cannot insert. Instance already exists")) {
                return new OhResult(false, 21);
            }
            throw new OhDataCallException("response code is " + statusCode + " " + connection.getResponseCode() + " " + connection.getResponseMessage() + " with error details " + errorText + " with payload " + json.toString() + " to URL " + absolutUri);
        }
        catch (IOException | URISyntaxException | EdmException | EntityProviderException | ConnectionFactoryException e) {
            throw new OhDataCallException((Exception)e);
        }
    }

    private String getErrornousConnectionMessage(HttpURLConnection connection) throws IOException {
        String errorText = "";
        if (connection != null) {
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                errorText = StreamAndStringTools.toString(errorStream, "UTF-8");
            } else {
                InputStream inputStream = connection.getInputStream();
                if (inputStream != null) {
                    errorText = StreamAndStringTools.toString(inputStream, "UTF-8");
                }
            }
        }
        return errorText;
    }

    public OhResult updateEntry(String entitySetName, Object id, JSONObject json) throws OhDataCallException {
        try {
            String serviceUri = this.urlPath;
            String absolutUri = this.createUri(serviceUri, entitySetName, id);
            String contentType = APPLICATION_JSON;
            Edm edm = this.readEdm();
            HttpURLConnection connection = (HttpURLConnection)this.cf.getConnection(absolutUri);
            connection.setRequestMethod(HTTP_METHOD_PUT);
            String csrfToken = this.getCSRFToken(absolutUri);
            if (csrfToken != null) {
                connection.addRequestProperty("x-csrf-token", csrfToken);
            }
            connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
            connection.setRequestProperty("Accept", contentType);
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("DataServiceVersion", "2.0");
            connection.setRequestProperty("X-Requested-With", "XMLHttpRequest");
            connection.setRequestProperty("X-Requested-With", "XMLHttpRequest");
            this.setCookies(connection);
            EdmEntityContainer entityContainer = edm.getDefaultEntityContainer();
            EdmEntitySet entitySet = entityContainer.getEntitySet(entitySetName);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Length", new Integer(json.toString().getBytes().length).toString());
            OutputStream os = connection.getOutputStream();
            StreamAndStringTools.write(json.toString(), os, "UTF-8");
            os.flush();
            connection.connect();
            ODataEntry entry = null;
            HttpStatusCodes statusCode = HttpStatusCodes.fromStatusCode((int)connection.getResponseCode());
            if (statusCode == HttpStatusCodes.NO_CONTENT) {
                this.getAndStoreCookies(connection);
                InputStream content = StreamAndStringTools.toInputStream(json.toString(), "UTF-8");
                entry = EntityProvider.readEntry((String)contentType, (EdmEntitySet)entitySet, (InputStream)content, (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
                connection.disconnect();
                return new OhResult(true, 30, entry);
            }
            if (statusCode == HttpStatusCodes.NOT_FOUND) {
                connection.disconnect();
                return new OhResult(false, 31);
            }
            throw this.handleConnectionError(connection, "response code is " + statusCode);
        }
        catch (IOException | URISyntaxException | EdmException | EntityProviderException | ConnectionFactoryException e) {
            throw new OhDataCallException((Exception)e);
        }
    }

    public OhResult deleteEntry(String entityName, Object id) throws OhDataCallException {
        try {
            String serviceUri = this.urlPath;
            String absolutUri = this.createUri(serviceUri, entityName, id);
            String csrfUri = this.createUri(serviceUri, entityName, null);
            String csrfToken = this.getCSRFToken(csrfUri);
            HttpURLConnection connection = (HttpURLConnection)this.cf.getConnection(absolutUri);
            if (csrfToken != null) {
                connection.addRequestProperty("x-csrf-token", csrfToken);
            }
            connection.setRequestMethod(HTTP_METHOD_DELETE);
            connection.setRequestProperty("Accept", APPLICATION_XML);
            this.setCookies(connection);
            connection.connect();
            HttpStatusCodes statusCode = HttpStatusCodes.fromStatusCode((int)connection.getResponseCode());
            if (statusCode == HttpStatusCodes.NO_CONTENT) {
                this.getAndStoreCookies(connection);
                connection.disconnect();
                return new OhResult(true, 40);
            }
            if (statusCode == HttpStatusCodes.NOT_FOUND) {
                return new OhResult(false, 1);
            }
            throw this.handleConnectionError(connection, "response code is " + statusCode);
        }
        catch (IOException | URISyntaxException | ConnectionFactoryException e) {
            throw new OhDataCallException(e);
        }
    }

    private OhDataCallException handleConnectionError(HttpURLConnection connection, String outsideErrorText) throws IOException {
        String errorText = this.getErrornousConnectionMessage(connection);
        String fullError = outsideErrorText + " " + connection.getResponseCode() + " " + connection.getResponseMessage() + " with error details " + errorText;
        connection.disconnect();
        return new OhDataCallException(fullError);
    }

    private String createUri(String serviceUri, String entitySetName, Object id) throws UnsupportedEncodingException {
        return this.createUri(serviceUri, entitySetName, id, null);
    }

    private String createUri(String serviceUri, String entitySetName, Object id, OhQuery query) throws UnsupportedEncodingException {
        StringBuilder absolutUri = new StringBuilder(serviceUri).append(SEPARATOR).append(entitySetName);
        if (id != null) {
            if (id instanceof String) {
                id = URLEncoder.encode((String)id, "UTF-8");
                absolutUri.append("('").append(id).append("')");
            } else {
                absolutUri.append("(").append(id).append(")");
            }
        }
        if (query != null) {
            String paramString = query.generateParameterString();
            absolutUri.append("?").append(paramString);
        }
        return absolutUri.toString();
    }

    private String getCSRFToken(String absolutUri) throws IOException, ConnectionFactoryException, OhDataCallException, URISyntaxException {
        String url = absolutUri;
        HttpURLConnection c = (HttpURLConnection)this.cf.getConnection(url);
        c.setRequestProperty("x-csrf-Token", "Fetch");
        c.setRequestProperty("Accept", APPLICATION_JSON);
        c.setRequestMethod(HTTP_METHOD_GET);
        this.setCookies(c);
        c.connect();
        if (c.getResponseCode() == 200) {
            String csrf = c.getHeaderField("x-csrf-token");
            this.getAndStoreCookies(c);
            return csrf;
        }
        throw this.handleConnectionError(c, "error calling csrf token" + url);
    }

    private String executeGET(String urlPath, String contentType) throws OhDataCallException {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.cf.getConnection(urlPath);
            conn.setRequestProperty("Accept", contentType);
            conn.connect();
            if (conn.getResponseCode() == 200) {
                InputStream is = conn.getInputStream();
                String response = StreamAndStringTools.toString(is, "UTF-8");
                is.close();
                conn.disconnect();
                return response;
            }
            throw this.handleConnectionError(conn, "HTTP Error Code " + conn.getResponseCode() + " " + conn.getResponseMessage());
        }
        catch (MalformedURLException e) {
            throw new OhDataCallException(e);
        }
        catch (IOException e) {
            throw new OhDataCallException(e);
        }
        catch (ConnectionFactoryException e) {
            throw new OhDataCallException(e);
        }
    }
}

