/*
 * Decompiled with CFR 0.152.
 */
package org.doktorodata.ohdata.client.tools.stubgeneration;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Generated;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.doktorodata.ohdata.client.base.OhCaller;
import org.doktorodata.ohdata.client.entityaccess.model.BaseEntity;
import org.doktorodata.ohdata.client.entityaccess.model.BaseEntityTools;
import org.doktorodata.ohdata.client.exceptions.ConnectionFactoryException;
import org.doktorodata.ohdata.client.exceptions.OhDataCallException;
import org.doktorodata.ohdata.client.exceptions.StubGenerationException;
import org.doktorodata.ohdata.connectivity.ConnectionFactory;

public class EntityStubGenerator {
    public static final String SUB_PACKAGE = "entities";
    private String localFolder;
    private String basePackage;
    private String destination;
    private String[] entitiesToGen = null;

    public EntityStubGenerator(String basePackage, String destination) {
        this.localFolder = ".";
        this.basePackage = basePackage;
        this.destination = destination;
    }

    public EntityStubGenerator(String basePackage, String destination, String localFolder) {
        this.basePackage = basePackage;
        this.localFolder = localFolder;
        this.destination = destination;
    }

    public void setEntitiesToGenerate(String[] entities) {
        this.entitiesToGen = entities;
    }

    public void generateEntityStubs() throws StubGenerationException, ConnectionFactoryException, EdmException, OhDataCallException, IOException, JClassAlreadyExistsException {
        this.generateEntityStubs("");
    }

    public void generateEntityStubs(String path) throws StubGenerationException, ConnectionFactoryException, EdmException, OhDataCallException, IOException, JClassAlreadyExistsException {
        String backendPath = path;
        ConnectionFactory cf = ConnectionFactory.createFactory(this.destination);
        OhCaller vda = new OhCaller(cf, backendPath);
        Edm edm = vda.readEdm();
        List es = edm.getDefaultEntityContainer().getEntitySets();
        JCodeModel cm = new JCodeModel();
        JClass betools = cm.ref(BaseEntityTools.class);
        for (EdmEntitySet entity : es) {
            entity.getEntityType();
            String simpleName = entity.getName();
            if (!this.shallBeGenerated(simpleName)) continue;
            String fullPackage = this.basePackage + "." + SUB_PACKAGE;
            if (fullPackage.endsWith(".")) {
                fullPackage = fullPackage.substring(0, fullPackage.length() - 1);
            }
            String fullPath = this.localFolder + File.separator + fullPackage.replaceAll("\\.", "\\" + File.separator) + File.separator;
            new File(fullPath).mkdirs();
            String className = EntityStubGenerator.firstUpper(simpleName);
            JDefinedClass clz = cm._class(fullPackage + "." + className);
            clz.annotate(Generated.class).param("value", "DoktorOData - OhData-Client");
            clz._extends(BaseEntity.class);
            JFieldVar fieldEntity = clz.field(17, String.class, "_ENTITY_NAME", JExpr.lit((String)entity.getName()));
            clz.method(1, String.class, "getEntityName").body()._return((JExpression)fieldEntity);
            HashMap<String, JFieldVar> propFields = new HashMap<String, JFieldVar>();
            this.generateProperties((EdmStructuralType)entity.getEntityType(), clz, cm, edm, propFields, "");
            JMethod methKey = clz.method(1, String.class, "getKey");
            List keyProps = entity.getEntityType().getKeyProperties();
            if (keyProps.size() == 1) {
                EdmProperty keyProp = (EdmProperty)keyProps.get(0);
                String name = keyProp.getName();
                methKey.body()._return((JExpression)betools.staticInvoke("convertToString").arg(JExpr.direct((String)name)));
            } else if (keyProps.size() > 1) {
                JVar keyString = methKey.body().decl((JType)cm.ref(String.class), "_key", JExpr.lit((String)""));
                for (int i = 0; i < keyProps.size(); ++i) {
                    EdmProperty keyProp = (EdmProperty)keyProps.get(i);
                    String keyName = keyProp.getName();
                    if (i == 0) {
                        methKey.body().assign((JAssignmentTarget)keyString, JExpr.lit((String)keyName).plus(JExpr.lit((String)"=")).plus((JExpression)betools.staticInvoke("convertToString").arg(JExpr.direct((String)keyName))));
                        continue;
                    }
                    methKey.body().assign((JAssignmentTarget)keyString, keyString.plus(JExpr.lit((String)",").plus(JExpr.lit((String)keyName).plus(JExpr.lit((String)"=")).plus((JExpression)betools.staticInvoke("convertToString").arg(JExpr.direct((String)keyName))))));
                }
                methKey.body()._return((JExpression)keyString);
            } else {
                throw new StubGenerationException("Entity has no key property / currently not supported");
            }
            System.out.println("Writing " + entity.getName() + " to " + fullPath + simpleName + ".java");
        }
        File file = new File(this.localFolder);
        file.mkdirs();
        cm.build(file);
    }

    private void generateProperties(EdmStructuralType type, JDefinedClass clz, JCodeModel cm, Edm edm, HashMap<String, JFieldVar> propFields, String prefix) throws EdmException, StubGenerationException {
        List props = type.getPropertyNames();
        for (String propName : props) {
            EdmTyped prop = type.getProperty(propName);
            String name = prefix + prop.getName();
            if (prop.getType().getKind() == EdmTypeKind.SIMPLE) {
                Class typeClz = BaseEntityTools.getClassTypeForJSONType(prop.getType().getName());
                JFieldVar fieldProp = clz.field(4, typeClz, name, null);
                JMethod methGet = clz.method(1, typeClz, "get" + EntityStubGenerator.firstUpper(name));
                methGet.body()._return((JExpression)fieldProp);
                JMethod methSet = clz.method(1, Void.TYPE, "set" + EntityStubGenerator.firstUpper(name));
                methSet.body().assign((JAssignmentTarget)fieldProp, (JExpression)methSet.param(typeClz, "_" + name));
                propFields.put(name, fieldProp);
                continue;
            }
            if (prop.getType().getKind() != EdmTypeKind.COMPLEX) continue;
            EdmComplexType cplxType = edm.getComplexType(prop.getType().getNamespace(), prop.getType().getName());
            this.generateProperties((EdmStructuralType)cplxType, clz, cm, edm, propFields, prefix + prop.getType().getName() + "_");
        }
    }

    private boolean shallBeGenerated(String simpleName) {
        if (this.entitiesToGen == null) {
            return true;
        }
        for (int i = 0; i < this.entitiesToGen.length; ++i) {
            if (!this.entitiesToGen[i].equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    private static String firstUpper(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

