/*
 * Decompiled with CFR 0.152.
 */
package org.doktorodata.ohdata.client.entityaccess;

import java.util.Iterator;
import java.util.LinkedList;
import org.doktorodata.ohdata.client.base.OhQuery;
import org.doktorodata.ohdata.client.entityaccess.OhEntityAccess;
import org.doktorodata.ohdata.client.entityaccess.OhEntityCallback;
import org.doktorodata.ohdata.client.entityaccess.OhEntityResult;
import org.doktorodata.ohdata.client.entityaccess.model.BaseEntity;

public class OhEntityIterator<T extends BaseEntity>
implements Iterator<T>,
OhEntityCallback<T> {
    private OhEntityAccess<T> oda;
    private LinkedList<T> itemsLoaded = new LinkedList();
    private int skip = 0;
    private OhQuery query;
    private boolean currentlyLoading = false;
    private boolean errorState = false;
    private boolean hasBeenStarted = false;
    private Exception errorStateException;
    private String errorStateText;
    public static int LOAD_SIZE = 10;
    public static int CONTINUE_LOADING_LIMIT = 2;

    public OhEntityIterator(OhEntityAccess<T> oda, OhQuery query) {
        this.oda = oda;
        this.query = query;
        if (this.query == null) {
            this.query = new OhQuery();
        }
    }

    public void startLoading() {
        this.hasBeenStarted = true;
        this.query.top(LOAD_SIZE);
        this.query.skip(0);
        this.loadNextSet();
    }

    public boolean hasError() {
        return this.errorState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNextSet() {
        if (this.errorState) {
            return;
        }
        this.query.skip(this.skip);
        this.skip += LOAD_SIZE;
        LinkedList<T> linkedList = this.itemsLoaded;
        synchronized (linkedList) {
            this.currentlyLoading = true;
            this.oda.queryAsync(this.query, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callSuccess(OhEntityResult<T> result) {
        LinkedList<T> linkedList = this.itemsLoaded;
        synchronized (linkedList) {
            this.itemsLoaded.addAll(result.getFeed());
            this.currentlyLoading = false;
            this.itemsLoaded.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callError(int statusCode, String errorText, Exception e) {
        LinkedList<T> linkedList = this.itemsLoaded;
        synchronized (linkedList) {
            this.errorState = true;
            this.errorStateText = errorText;
            this.errorStateException = e;
            this.currentlyLoading = false;
            this.itemsLoaded.notifyAll();
        }
    }

    public boolean isErrorState() {
        return this.errorState;
    }

    public Exception getErrorStateException() {
        return this.errorStateException;
    }

    public String getErrorStateText() {
        return this.errorStateText;
    }

    public int getCount() {
        return this.itemsLoaded.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        LinkedList<T> linkedList = this.itemsLoaded;
        synchronized (linkedList) {
            if (!this.hasBeenStarted) {
                this.startLoading();
            }
            if (this.itemsLoaded.size() > 0) {
                return true;
            }
            while (this.currentlyLoading) {
                try {
                    this.itemsLoaded.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.itemsLoaded.size() > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        LinkedList<T> linkedList = this.itemsLoaded;
        synchronized (linkedList) {
            if (this.itemsLoaded.size() < CONTINUE_LOADING_LIMIT && !this.currentlyLoading) {
                this.loadNextSet();
            }
            return (T)((BaseEntity)this.itemsLoaded.poll());
        }
    }

    @Override
    public void remove() {
    }
}

