/*
 * Decompiled with CFR 0.152.
 */
package org.doktorodata.ohdata.client.entityaccess;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.doktorodata.ohdata.client.base.OhCallerFactory;
import org.doktorodata.ohdata.client.base.OhQuery;
import org.doktorodata.ohdata.client.base.OhResult;
import org.doktorodata.ohdata.client.entityaccess.OhEntityCallback;
import org.doktorodata.ohdata.client.entityaccess.OhEntityResult;
import org.doktorodata.ohdata.client.entityaccess.model.BaseEntity;
import org.doktorodata.ohdata.client.entityaccess.model.BaseEntityTools;
import org.doktorodata.ohdata.client.exceptions.OhDataCallException;
import org.doktorodata.ohdata.client.exceptions.OhEntityAccessException;
import org.json.JSONObject;

public class OhEntityAccess<T extends BaseEntity> {
    private static String FIELDNAME_ENTITYNAME = "_ENTITY_NAME";
    private Class<? extends BaseEntity> clz;
    private OhCallerFactory ocf;

    public OhEntityAccess(OhCallerFactory ocf, Class<? extends BaseEntity> clz) {
        this.clz = clz;
        this.ocf = ocf;
    }

    public OhEntityResult<T> query() throws OhEntityAccessException {
        return this.query(null);
    }

    public OhEntityResult<T> query(OhQuery query) throws OhEntityAccessException {
        try {
            String entityName = this.getEntityName();
            OhResult readResult = this.ocf.getODataCaller().readFeed(entityName, query);
            OhEntityResult result = new OhEntityResult(readResult);
            if (readResult.isSuccess()) {
                ODataFeed feed = readResult.getFeed();
                ArrayList<T> entries = new ArrayList<T>();
                List odEntries = feed.getEntries();
                for (ODataEntry odEntry : odEntries) {
                    T newEntry = this.mapEntity(odEntry);
                    entries.add(newEntry);
                }
                result.setFeed(entries);
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException | OhDataCallException e) {
            throw new OhEntityAccessException(e);
        }
    }

    public OhEntityResult<T> get(T entry) throws OhEntityAccessException {
        return this.get(((BaseEntity)entry).getKey());
    }

    public OhEntityResult<T> get(Object key) throws OhEntityAccessException {
        try {
            String entityName = this.getEntityName();
            OhResult readResult = this.ocf.getODataCaller().readEntry(entityName, key);
            OhEntityResult<T> result = new OhEntityResult<T>(readResult);
            if (readResult.isSuccess()) {
                ODataEntry odEntry = readResult.getEntry();
                T newEntry = this.mapEntity(odEntry);
                result.setEntry(newEntry);
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException | OhDataCallException e) {
            throw new OhEntityAccessException(e);
        }
    }

    public OhEntityResult<T> create(T entry) throws OhEntityAccessException {
        try {
            JSONObject jsonData = BaseEntityTools.convertToJSONObject(this.clz, entry);
            String entityName = this.getEntityName();
            OhResult result = this.ocf.getODataCaller().createEntry(entityName, jsonData);
            OhEntityResult<T> entityResult = new OhEntityResult<T>(result);
            if (result.getEntry() != null) {
                entityResult.setEntry(this.mapEntity(result.getEntry()));
            } else if (entityResult.getStatusCode() == 21) {
                entityResult.setEntry(entry);
            }
            return entityResult;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException | OhDataCallException | OhEntityAccessException e) {
            throw new OhEntityAccessException(e);
        }
    }

    public OhEntityResult<T> update(T entry) throws OhEntityAccessException {
        try {
            JSONObject jsonData = BaseEntityTools.convertToJSONObject(this.clz, entry);
            String entityName = this.getEntityName();
            String key = ((BaseEntity)entry).getKey();
            OhResult result = this.ocf.getODataCaller().updateEntry(entityName, key, jsonData);
            OhEntityResult<T> entityResult = new OhEntityResult<T>(result);
            entityResult.setEntry(this.mapEntity(result.getEntry()));
            return entityResult;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException | OhDataCallException | OhEntityAccessException e) {
            throw new OhEntityAccessException(e);
        }
    }

    public OhEntityResult<T> upsert(T entry) throws OhEntityAccessException {
        try {
            OhResult writeResult;
            JSONObject jsonData = BaseEntityTools.convertToJSONObject(this.clz, entry);
            String entityName = this.getEntityName();
            String key = ((BaseEntity)entry).getKey();
            OhResult readResult = this.ocf.getODataCaller().readEntry(entityName, key);
            if (readResult.getStatusCode() == 1) {
                writeResult = this.ocf.getODataCaller().createEntry(entityName, jsonData);
            } else if (readResult.getStatusCode() == 10) {
                writeResult = this.ocf.getODataCaller().updateEntry(entityName, key, jsonData);
            } else {
                throw new OhEntityAccessException("Unknown status code " + readResult.getStatusCode() + " - " + readResult.getError());
            }
            OhEntityResult<T> entityResult = new OhEntityResult<T>(writeResult);
            entityResult.setEntry(this.mapEntity(writeResult.getEntry()));
            return entityResult;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException | OhDataCallException | OhEntityAccessException e) {
            throw new OhEntityAccessException(e);
        }
    }

    public OhEntityResult<T> delete(T entry) throws OhEntityAccessException {
        try {
            String entityName = this.getEntityName();
            String key = ((BaseEntity)entry).getKey();
            OhResult deleteResult = this.ocf.getODataCaller().deleteEntry(entityName, key);
            OhEntityResult<T> entityResult = new OhEntityResult<T>(deleteResult);
            if (deleteResult.getEntry() != null) {
                entityResult.setEntry(this.mapEntity(deleteResult.getEntry()));
            }
            return entityResult;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException | OhDataCallException | OhEntityAccessException e) {
            throw new OhEntityAccessException(e);
        }
    }

    private String getEntityName() throws OhEntityAccessException {
        try {
            return (String)this.clz.getField(FIELDNAME_ENTITYNAME).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new OhEntityAccessException("Error accessing class data " + e.toString());
        }
    }

    private T mapEntity(ODataEntry odEntry) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Set keys = odEntry.getProperties().keySet();
        BaseEntity entry = this.clz.newInstance();
        for (String key : keys) {
            Object value = odEntry.getProperties().get(key);
            this.mapValue(entry, key, value);
        }
        return (T)entry;
    }

    private void mapValue(T entry, String key, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = BaseEntityTools.getSetterMethod(this.clz, key);
        if (m != null) {
            m.invoke(entry, value);
        } else if (value instanceof HashMap) {
            HashMap cplxTypeValues = (HashMap)value;
            Set subKeys = cplxTypeValues.keySet();
            for (String subKey : subKeys) {
                this.mapValue(entry, key + "_" + subKey, cplxTypeValues.get(subKey));
            }
        } else {
            System.out.println("Method for " + key + " not found - " + value.getClass());
        }
    }

    public void queryAsync(OhQuery query, OhEntityCallback<T> callback) {
        new FeedThread(query, callback).start();
    }

    private class FeedThread
    extends Thread {
        private OhEntityCallback<T> callback;
        private OhQuery query;

        public FeedThread(OhQuery query, OhEntityCallback<T> callback) {
            this.query = query;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                OhEntityResult result = OhEntityAccess.this.query(this.query);
                if (result.isSuccess()) {
                    this.callback.callSuccess(result);
                } else {
                    this.callback.callError(result.getStatusCode(), result.getError(), null);
                }
            }
            catch (OhEntityAccessException e) {
                e.printStackTrace();
                this.callback.callError(99, e.toString(), e);
            }
        }
    }
}

