/*
 * Decompiled with CFR 0.152.
 */
package org.digibooster.spring.batch.security.listener;

import java.io.Serializable;
import org.digibooster.spring.batch.listener.JobExecutionContextListener;
import org.digibooster.spring.batch.util.SerializableJobParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.StepExecution;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class JobExecutionSecurityContextListener
implements JobExecutionContextListener {
    private final Logger log = LoggerFactory.getLogger(JobExecutionSecurityContextListener.class);
    private static final String SECURITY_PARAM_NAME = "security-param";
    private static final ThreadLocal<Authentication> ORIGINAL_CONTEXT = new ThreadLocal();

    public void insertContextInfo(JobParametersBuilder jobParametersBuilder) {
        this.log.debug("Insert the security context");
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            jobParametersBuilder.addParameter(SECURITY_PARAM_NAME, (JobParameter)new SerializableJobParameter((Serializable)authentication));
        }
    }

    public void fillJobExecutionContext(JobExecution jobExecution) {
        this.log.debug("Restore the scurity context");
        SerializableJobParameter authentication = (SerializableJobParameter)jobExecution.getJobParameters().getParameters().get(SECURITY_PARAM_NAME);
        if (authentication != null) {
            jobExecution.getExecutionContext().put(SECURITY_PARAM_NAME, (Object)((Authentication)authentication.getValue()));
        } else {
            this.log.error("Could not find parameter {} in order to restore the security context", (Object)SECURITY_PARAM_NAME);
        }
    }

    public void removeFromJobExecutionContext(JobExecution jobExecution) {
        jobExecution.getExecutionContext().remove(SECURITY_PARAM_NAME);
    }

    public void restoreContext(StepExecution stepExecution) {
        if (stepExecution.getJobExecution().getExecutionContext().containsKey(SECURITY_PARAM_NAME)) {
            this.log.debug("Restore the security context");
            Authentication authentication = (Authentication)stepExecution.getJobExecution().getExecutionContext().get(SECURITY_PARAM_NAME);
            SecurityContext securityContext = SecurityContextHolder.getContext();
            ORIGINAL_CONTEXT.set(securityContext.getAuthentication());
            securityContext.setAuthentication(authentication);
        } else {
            this.log.error("Could not find key {} in the job execution context", (Object)SECURITY_PARAM_NAME);
        }
    }

    public void clearContext(StepExecution stepExecution) {
        this.log.debug("Clear the security context");
        SecurityContextHolder.clearContext();
        Authentication originalAuth = ORIGINAL_CONTEXT.get();
        if (originalAuth != null) {
            SecurityContextHolder.getContext().setAuthentication(originalAuth);
            ORIGINAL_CONTEXT.remove();
        }
    }
}

