/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelexport.solr.ltr.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.model.AdapterModel;
import org.apache.solr.ltr.model.ModelException;
import org.apache.solr.ltr.norm.Normalizer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.util.ModelGuesser;
import org.deeplearning4j.util.NetworkUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class ScoringModel
extends AdapterModel {
    private String serializedModelFileName;
    protected Model model;

    public ScoringModel(String name, List<Feature> features, List<Normalizer> norms, String featureStoreName, List<Feature> allFeatures, Map<String, Object> params) {
        super(name, features, norms, featureStoreName, allFeatures, params);
    }

    public void setSerializedModelFileName(String serializedModelFileName) {
        this.serializedModelFileName = serializedModelFileName;
    }

    public void init(SolrResourceLoader solrResourceLoader) throws ModelException {
        super.init(solrResourceLoader);
        try {
            this.model = this.restoreModel(this.openInputStream());
        }
        catch (Exception e) {
            throw new ModelException("Failed to restore model from given file (" + this.serializedModelFileName + ")", e);
        }
        this.validate();
    }

    protected InputStream openInputStream() throws IOException {
        return this.solrResourceLoader.openResource(this.serializedModelFileName);
    }

    protected Model restoreModel(InputStream inputStream) throws Exception {
        File instanceDir = this.solrResourceLoader.getInstancePath().toFile();
        return ModelGuesser.loadModelGuess((InputStream)inputStream, (File)instanceDir);
    }

    protected void validate() throws ModelException {
        super.validate();
        if (this.serializedModelFileName == null) {
            throw new ModelException("no serializedModelFileName configured for model " + this.name);
        }
        if (this.model != null) {
            this.validateModel();
        }
    }

    protected void validateModel() throws ModelException {
        try {
            float[] mockModelFeatureValuesNormalized = new float[this.features.size()];
            this.score(mockModelFeatureValuesNormalized);
        }
        catch (Exception exception) {
            throw new ModelException("score(...) test failed for model " + this.name, exception);
        }
    }

    public float score(float[] modelFeatureValuesNormalized) {
        return ScoringModel.outputScore(this.model, modelFeatureValuesNormalized);
    }

    public static float outputScore(Model model, float[] modelFeatureValuesNormalized) {
        INDArray input = Nd4j.create((float[])modelFeatureValuesNormalized);
        INDArray output = NetworkUtils.output((Model)model, (INDArray)input);
        return output.getFloat(0L);
    }

    public Explanation explain(LeafReaderContext context, int doc, float finalScore, List<Explanation> featureExplanations) {
        StringBuilder sb = new StringBuilder();
        sb.append("(name=").append(this.getName());
        sb.append(",class=").append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(",featureValues=[");
        for (int i = 0; i < featureExplanations.size(); ++i) {
            Explanation featureExplain = featureExplanations.get(i);
            if (i > 0) {
                sb.append(',');
            }
            String key = ((Feature)this.features.get(i)).getName();
            sb.append(key).append('=').append(featureExplain.getValue());
        }
        sb.append("])");
        return Explanation.match((float)finalScore, (String)sb.toString(), (Explanation[])new Explanation[0]);
    }
}

