/*
 * Decompiled with CFR 0.152.
 */
package org.ddbstoolkit.toolkit.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntity;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntityProperty;
import org.ddbstoolkit.toolkit.jdbc.JDBCConnector;
import org.ddbstoolkit.toolkit.jdbc.JDBCPreparedStatements;
import org.ddbstoolkit.toolkit.jdbc.PreparedStatementType;

public class JDBCPreparedStatementManager {
    private final JDBCConnector myConnector;
    private final Map<String, JDBCPreparedStatements> mapStatements;

    public JDBCPreparedStatementManager(JDBCConnector myConnector) {
        this.myConnector = myConnector;
        this.mapStatements = new HashMap<String, JDBCPreparedStatements>();
    }

    public PreparedStatement getJDBCPreparedStatements(DDBSEntity<DDBSEntityProperty> ddbsEntity, PreparedStatementType type) {
        if (this.mapStatements.get(ddbsEntity.getDatastoreEntityName()) == null) {
            this.mapStatements.put(ddbsEntity.getDatastoreEntityName(), new JDBCPreparedStatements());
        }
        return this.mapStatements.get(ddbsEntity.getDatastoreEntityName()).getPreparedStatement(type);
    }

    public PreparedStatement setJDBCPreparedStatements(DDBSEntity<DDBSEntityProperty> ddbsEntity, PreparedStatementType type, String query) throws SQLException {
        if (this.mapStatements.get(ddbsEntity.getDatastoreEntityName()) == null && !this.hasUnknownDDBSEntityProperties(ddbsEntity)) {
            this.mapStatements.put(ddbsEntity.getDatastoreEntityName(), new JDBCPreparedStatements());
        }
        PreparedStatement preparedStatement = this.myConnector.prepareStatement(query);
        this.mapStatements.get(ddbsEntity.getDatastoreEntityName()).setPreparedStatement(type, preparedStatement);
        return preparedStatement;
    }

    private boolean hasUnknownDDBSEntityProperties(DDBSEntity<DDBSEntityProperty> ddbsEntity) {
        for (DDBSEntityProperty ddbsEntityProperty : ddbsEntity.getEntityProperties()) {
            if (ddbsEntityProperty.getDdbsToolkitSupportedEntity() != null) continue;
            return true;
        }
        return false;
    }
}

