/*
 * Decompiled with CFR 0.152.
 */
package org.ddbstoolkit.toolkit.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.ddbstoolkit.toolkit.core.DDBSTransaction;
import org.ddbstoolkit.toolkit.core.IEntity;
import org.ddbstoolkit.toolkit.core.TransactionCommand;
import org.ddbstoolkit.toolkit.core.exception.DDBSToolkitException;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntity;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntityProperty;
import org.ddbstoolkit.toolkit.jdbc.JDBCConnectionPool;
import org.ddbstoolkit.toolkit.jdbc.JDBCConnector;
import org.ddbstoolkit.toolkit.jdbc.JDBCEntityManager;
import org.ddbstoolkit.toolkit.jdbc.JDBCPreparedStatementManager;
import org.ddbstoolkit.toolkit.jdbc.PreparedStatementType;

public abstract class JDBCPoolManager
extends JDBCEntityManager {
    protected JDBCConnectionPool connectionPool;

    public JDBCPoolManager(JDBCConnectionPool connectionPool) {
        super(null);
        this.connectionPool = connectionPool;
    }

    @Override
    public boolean isOpen() throws DDBSToolkitException {
        return true;
    }

    @Override
    public void open() throws DDBSToolkitException {
        try {
            this.jdbcConnector = this.connectionPool.getJDBCConnector(this.connectionPool.getConnection());
            this.jdbcPreparedStatementManager = new JDBCPreparedStatementManager(this.jdbcConnector);
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during opening SQL connection", (Throwable)sqle);
        }
    }

    private <T extends IEntity> void testConnection(JDBCConnector connector, T object) throws DDBSToolkitException {
        try {
            if (!connector.isOpen()) {
                throw new DDBSToolkitException("The database connection is not opened");
            }
            if (object == null) {
                throw new IllegalArgumentException("The object passed in parameter is null");
            }
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error has occured while checking the connection", (Throwable)sqle);
        }
    }

    @Override
    public DDBSTransaction executeTransaction(DDBSTransaction transaction) throws DDBSToolkitException {
        JDBCConnector connection = null;
        try {
            transaction = this.connectionPool.createSession();
            connection = this.connectionPool.getJDBCConnector(this.connectionPool.getConnection(transaction));
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error while beginning the transaction", (Throwable)sqle);
        }
        JDBCPreparedStatementManager jdbcPreparedStatementManager = new JDBCPreparedStatementManager(connection);
        for (TransactionCommand transactionCommand : transaction.getTransactionCommands()) {
            switch (transactionCommand.getDataAction()) {
                case ADD: {
                    this.add(jdbcPreparedStatementManager, connection, transactionCommand.getEntity());
                    break;
                }
                case UPDATE: {
                    this.update(jdbcPreparedStatementManager, connection, transactionCommand.getEntity());
                    break;
                }
                case DELETE: {
                    this.delete(jdbcPreparedStatementManager, connection, transactionCommand.getEntity());
                    break;
                }
                case CREATE_ENTITY: {
                    this.createEntity(jdbcPreparedStatementManager, connection, transactionCommand.getEntity());
                    break;
                }
            }
        }
        return transaction;
    }

    private boolean add(JDBCPreparedStatementManager jdbcPreparedStatementManager, JDBCConnector connection, IEntity objectToAdd) throws DDBSToolkitException {
        this.testConnection(connection, objectToAdd);
        try {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(objectToAdd);
            PreparedStatement preparedRequest = jdbcPreparedStatementManager.getJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.ADD);
            if (preparedRequest == null) {
                String sqlAddString = this.getInsertSQLString((DDBSEntity<DDBSEntityProperty>)ddbsEntity);
                preparedRequest = jdbcPreparedStatementManager.setJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.ADD, sqlAddString);
            }
            this.jdbcConditionConverter.prepareParametersPreparedStatement(preparedRequest, ddbsEntity.getEntityIDProperties(), objectToAdd);
            return connection.executePreparedQuery(preparedRequest) == 1;
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
    }

    private boolean update(JDBCPreparedStatementManager jdbcPreparedStatementManager, JDBCConnector connection, IEntity objectToUpdate) throws DDBSToolkitException {
        this.testConnection(connection, objectToUpdate);
        try {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(objectToUpdate);
            PreparedStatement preparedRequest = jdbcPreparedStatementManager.getJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.UPDATE);
            if (preparedRequest == null) {
                String sqlUpdateString = this.getUpdateSQLString((DDBSEntity<DDBSEntityProperty>)ddbsEntity);
                preparedRequest = jdbcPreparedStatementManager.setJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.UPDATE, sqlUpdateString);
            }
            ArrayList listPreparedEntities = new ArrayList();
            listPreparedEntities.addAll(ddbsEntity.getEntityNonIDProperties());
            listPreparedEntities.addAll(ddbsEntity.getEntityIDProperties());
            this.jdbcConditionConverter.prepareParametersPreparedStatement(preparedRequest, ddbsEntity.getEntityIDProperties(), objectToUpdate);
            return connection.executePreparedQuery(preparedRequest) == 1;
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
    }

    public boolean delete(JDBCPreparedStatementManager jdbcPreparedStatementManager, JDBCConnector connection, IEntity objectToDelete) throws DDBSToolkitException {
        this.testConnection(connection, objectToDelete);
        try {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(objectToDelete);
            PreparedStatement preparedRequest = jdbcPreparedStatementManager.getJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.DELETE);
            if (preparedRequest == null) {
                String sqlDeleteString = this.getDeleteSQLString((DDBSEntity<DDBSEntityProperty>)ddbsEntity);
                preparedRequest = jdbcPreparedStatementManager.setJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.DELETE, sqlDeleteString);
            }
            this.jdbcConditionConverter.prepareParametersPreparedStatement(preparedRequest, ddbsEntity.getEntityIDProperties(), objectToDelete);
            return connection.executePreparedQuery(preparedRequest) == 1;
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
    }

    public boolean createEntity(JDBCPreparedStatementManager jdbcPreparedStatementManager, JDBCConnector connection, IEntity objectToCreate) throws DDBSToolkitException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commit(DDBSTransaction transaction) throws DDBSToolkitException {
        try {
            this.connectionPool.getConnection(transaction).commit();
            this.connectionPool.endSession(transaction);
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error while beginning the transaction", (Throwable)sqle);
        }
    }

    @Override
    public void rollback(DDBSTransaction transaction) throws DDBSToolkitException {
        try {
            this.connectionPool.getConnection(transaction).rollback();
            this.connectionPool.endSession(transaction);
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error while beginning the transaction", (Throwable)sqle);
        }
    }
}

