/*
 * Decompiled with CFR 0.152.
 */
package org.ddbstoolkit.toolkit.jdbc;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ddbstoolkit.toolkit.core.DDBSTransaction;
import org.ddbstoolkit.toolkit.core.DistributableEntityManager;
import org.ddbstoolkit.toolkit.core.IEntity;
import org.ddbstoolkit.toolkit.core.TransactionCommand;
import org.ddbstoolkit.toolkit.core.conditions.Conditions;
import org.ddbstoolkit.toolkit.core.exception.DDBSToolkitException;
import org.ddbstoolkit.toolkit.core.generation.ImplementableEntity;
import org.ddbstoolkit.toolkit.core.orderby.OrderBy;
import org.ddbstoolkit.toolkit.core.reflexion.ClassInspector;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntity;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntityManager;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntityProperty;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSToolkitSupportedEntity;
import org.ddbstoolkit.toolkit.jdbc.JDBCConditionConverter;
import org.ddbstoolkit.toolkit.jdbc.JDBCConnector;
import org.ddbstoolkit.toolkit.jdbc.JDBCPreparedStatementManager;
import org.ddbstoolkit.toolkit.jdbc.PreparedStatementType;

public abstract class JDBCEntityManager
implements DistributableEntityManager {
    protected JDBCConnector jdbcConnector;
    protected JDBCPreparedStatementManager jdbcPreparedStatementManager;
    protected DDBSEntityManager<DDBSEntity<DDBSEntityProperty>> ddbsEntityManager;
    protected JDBCConditionConverter jdbcConditionConverter;

    public JDBCEntityManager(JDBCConnector jdbcConnector) {
        this.jdbcConnector = jdbcConnector;
        this.ddbsEntityManager = new DDBSEntityManager(new ClassInspector());
        this.jdbcConditionConverter = new JDBCConditionConverter(this.ddbsEntityManager);
    }

    public boolean isOpen() throws DDBSToolkitException {
        try {
            return this.jdbcConnector.isOpen();
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during checking SQL connection", (Throwable)sqle);
        }
    }

    public void open() throws DDBSToolkitException {
        try {
            this.jdbcConnector.open();
            this.jdbcPreparedStatementManager = new JDBCPreparedStatementManager(this.jdbcConnector);
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during opening SQL connection", (Throwable)sqle);
        }
    }

    public void close() throws DDBSToolkitException {
        try {
            this.jdbcConnector.close();
        }
        catch (SQLException e) {
            throw new DDBSToolkitException("Error during opening SQL connection", (Throwable)e);
        }
    }

    public void setAutoCommit(boolean isAutoCommit) throws DDBSToolkitException {
        try {
            this.jdbcConnector.setAutoCommit(isAutoCommit);
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error while committing the transaction", (Throwable)sqle);
        }
    }

    public void commit(DDBSTransaction transaction) throws DDBSToolkitException {
        try {
            this.jdbcConnector.commit();
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error while committing the transaction", (Throwable)sqle);
        }
    }

    public void rollback(DDBSTransaction transaction) throws DDBSToolkitException {
        try {
            this.jdbcConnector.rollback();
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error while rollbacking the transaction", (Throwable)sqle);
        }
    }

    public DDBSTransaction executeTransaction(DDBSTransaction transaction) throws DDBSToolkitException {
        for (TransactionCommand transactionCommand : transaction.getTransactionCommands()) {
            switch (transactionCommand.getDataAction()) {
                case ADD: {
                    this.add(transactionCommand.getEntity());
                    break;
                }
                case UPDATE: {
                    this.update(transactionCommand.getEntity());
                    break;
                }
                case DELETE: {
                    this.delete(transactionCommand.getEntity());
                    break;
                }
                case CREATE_ENTITY: {
                    this.createEntity(transactionCommand.getEntity());
                    break;
                }
            }
        }
        return transaction;
    }

    private <T extends IEntity> void testConnection(T object) throws DDBSToolkitException {
        try {
            if (!this.jdbcConnector.isOpen()) {
                throw new DDBSToolkitException("The database connection is not opened");
            }
            if (object == null) {
                throw new IllegalArgumentException("The object passed in parameter is null");
            }
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error has occured while checking the connection", (Throwable)sqle);
        }
    }

    private <T extends IEntity> String getSelectQueryString(T object, String conditionQueryString, OrderBy orderBy) {
        DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(object);
        StringBuilder listAllQuery = new StringBuilder();
        listAllQuery.append("SELECT ");
        Iterator iteratorProperties = ddbsEntity.getSupportedPrimaryTypeEntityProperties().iterator();
        while (iteratorProperties.hasNext()) {
            listAllQuery.append(((DDBSEntityProperty)iteratorProperties.next()).getPropertyName());
            if (!iteratorProperties.hasNext()) continue;
            listAllQuery.append(",");
        }
        listAllQuery.append(" FROM ");
        listAllQuery.append(ddbsEntity.getDatastoreEntityName());
        if (conditionQueryString != null && !conditionQueryString.isEmpty()) {
            listAllQuery.append(" WHERE ");
            listAllQuery.append(conditionQueryString);
        }
        if (orderBy != null) {
            DDBSEntityProperty ddbsEntityProperty = ddbsEntity.getDDBSEntityProperty(orderBy.getName());
            listAllQuery.append(" ORDER BY ");
            listAllQuery.append(ddbsEntityProperty.getPropertyName());
            switch (orderBy.getType()) {
                case ASC: {
                    listAllQuery.append(" ASC");
                    break;
                }
                case DESC: {
                    listAllQuery.append(" DESC");
                    break;
                }
            }
        }
        listAllQuery.append(";");
        return listAllQuery.toString();
    }

    public <T extends IEntity> List<T> listAll(T object, Conditions conditions, OrderBy orderBy) throws DDBSToolkitException {
        this.testConnection(object);
        try {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(object);
            String listAllQuery = this.getSelectQueryString(object, this.jdbcConditionConverter.getConditionsString(conditions, object), orderBy);
            PreparedStatement preparedRequest = this.jdbcConnector.prepareStatement(listAllQuery);
            this.jdbcConditionConverter.prepareStatement(preparedRequest, conditions, (DDBSEntity<DDBSEntityProperty>)ddbsEntity);
            ResultSet results = this.jdbcConnector.queryPreparedStatement(preparedRequest);
            if (object instanceof ImplementableEntity) {
                return ((ImplementableEntity)object).conversionResultSet(results, object);
            }
            return this.conversionResultSet(results, object);
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
    }

    public <T extends IEntity> List<T> listAllWithQueryString(T object, String conditionQueryString, OrderBy orderBy) throws DDBSToolkitException {
        this.testConnection(object);
        try {
            String listAllQuery = this.getSelectQueryString(object, conditionQueryString, orderBy);
            ResultSet results = this.jdbcConnector.query(listAllQuery);
            if (object instanceof ImplementableEntity) {
                return ((ImplementableEntity)object).conversionResultSet(results, object);
            }
            return this.conversionResultSet(results, object);
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
    }

    public <T extends IEntity> T read(T object) throws DDBSToolkitException {
        this.testConnection(object);
        try {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(object);
            PreparedStatement preparedRequest = this.jdbcPreparedStatementManager.getJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.READ);
            if (preparedRequest == null) {
                StringBuilder sqlReadWhereString = new StringBuilder();
                Iterator iteratorIDProperties = ddbsEntity.getEntityIDProperties().iterator();
                while (iteratorIDProperties.hasNext()) {
                    sqlReadWhereString.append(((DDBSEntityProperty)iteratorIDProperties.next()).getPropertyName());
                    sqlReadWhereString.append(" = ?");
                    if (!iteratorIDProperties.hasNext()) continue;
                    sqlReadWhereString.append(" AND ");
                }
                String sqlReadString = this.getSelectQueryString(object, sqlReadWhereString.toString(), null);
                preparedRequest = this.jdbcPreparedStatementManager.setJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.READ, sqlReadString);
            }
            this.jdbcConditionConverter.prepareParametersPreparedStatement(preparedRequest, ddbsEntity.getEntityIDProperties(), object);
            ResultSet results = this.jdbcConnector.queryPreparedStatement(preparedRequest);
            List<T> resultList = this.conversionResultSet(results, object);
            if (resultList.size() > 0) {
                return resultList.get(0);
            }
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
        return null;
    }

    public <T extends IEntity> T readLastElement(T object) throws DDBSToolkitException {
        this.testConnection(object);
        try {
            ResultSet results;
            List<T> resultList;
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(object);
            PreparedStatement preparedRequest = this.jdbcPreparedStatementManager.getJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.READ_LAST_ELEMENT);
            if (preparedRequest == null) {
                List ddbsIdProperties = ddbsEntity.getEntityIDProperties();
                if (ddbsIdProperties.isEmpty() || ddbsIdProperties.size() > 1) {
                    throw new DDBSToolkitException("There is more than one ID property");
                }
                StringBuilder sqlReadWhereString = new StringBuilder();
                sqlReadWhereString.append(((DDBSEntityProperty)ddbsIdProperties.get(0)).getPropertyName());
                sqlReadWhereString.append(" = (SELECT MAX(");
                sqlReadWhereString.append(((DDBSEntityProperty)ddbsIdProperties.get(0)).getPropertyName());
                sqlReadWhereString.append(") FROM ");
                sqlReadWhereString.append(ddbsEntity.getDatastoreEntityName());
                sqlReadWhereString.append(')');
                String sqlReadLastElementString = this.getSelectQueryString(object, sqlReadWhereString.toString(), null);
                preparedRequest = this.jdbcPreparedStatementManager.setJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.READ_LAST_ELEMENT, sqlReadLastElementString);
            }
            if (!(resultList = this.conversionResultSet(results = this.jdbcConnector.queryPreparedStatement(preparedRequest), object)).isEmpty()) {
                return resultList.get(0);
            }
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
        return null;
    }

    protected String getInsertSQLString(DDBSEntity<DDBSEntityProperty> ddbsEntity) {
        StringBuilder sqlAddString = new StringBuilder();
        StringBuilder sqlAddPart2String = new StringBuilder();
        sqlAddString.append("INSERT INTO ");
        sqlAddString.append(ddbsEntity.getDatastoreEntityName());
        sqlAddString.append(" (");
        Iterator iteratorProperties = ddbsEntity.getNotIncrementingEntityProperties().iterator();
        while (iteratorProperties.hasNext()) {
            sqlAddString.append(((DDBSEntityProperty)iteratorProperties.next()).getPropertyName());
            sqlAddPart2String.append('?');
            if (!iteratorProperties.hasNext()) continue;
            sqlAddString.append(',');
            sqlAddPart2String.append(',');
        }
        sqlAddString.append(") VALUES (");
        sqlAddString.append((CharSequence)sqlAddPart2String);
        sqlAddString.append(");");
        return sqlAddString.toString();
    }

    public boolean add(IEntity objectToAdd) throws DDBSToolkitException {
        this.testConnection(objectToAdd);
        try {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(objectToAdd);
            PreparedStatement preparedRequest = this.jdbcPreparedStatementManager.getJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.ADD);
            if (preparedRequest == null) {
                String sqlAddString = this.getInsertSQLString((DDBSEntity<DDBSEntityProperty>)ddbsEntity);
                preparedRequest = this.jdbcPreparedStatementManager.setJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.ADD, sqlAddString);
            }
            this.jdbcConditionConverter.prepareParametersPreparedStatement(preparedRequest, ddbsEntity.getEntityNonIDProperties(), objectToAdd);
            return this.jdbcConnector.executePreparedQuery(preparedRequest) == 1;
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
    }

    protected String getUpdateSQLString(DDBSEntity<DDBSEntityProperty> ddbsEntity) {
        StringBuilder sqlUpdateString = new StringBuilder();
        sqlUpdateString.append("UPDATE ");
        sqlUpdateString.append(ddbsEntity.getDatastoreEntityName());
        sqlUpdateString.append(" SET ");
        Iterator iteratorProperties = ddbsEntity.getEntityNonIDProperties().iterator();
        while (iteratorProperties.hasNext()) {
            sqlUpdateString.append(((DDBSEntityProperty)iteratorProperties.next()).getPropertyName());
            sqlUpdateString.append(" = ?");
            if (!iteratorProperties.hasNext()) continue;
            sqlUpdateString.append(',');
        }
        sqlUpdateString.append(" WHERE ");
        Iterator iteratorIDProperties = ddbsEntity.getEntityIDProperties().iterator();
        while (iteratorIDProperties.hasNext()) {
            sqlUpdateString.append(((DDBSEntityProperty)iteratorIDProperties.next()).getPropertyName());
            sqlUpdateString.append(" = ?");
            if (!iteratorIDProperties.hasNext()) continue;
            sqlUpdateString.append(" AND ");
        }
        return sqlUpdateString.toString();
    }

    public boolean update(IEntity objectToUpdate) throws DDBSToolkitException {
        this.testConnection(objectToUpdate);
        try {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(objectToUpdate);
            PreparedStatement preparedRequest = this.jdbcPreparedStatementManager.getJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.UPDATE);
            if (preparedRequest == null) {
                String sqlUpdateString = this.getUpdateSQLString((DDBSEntity<DDBSEntityProperty>)ddbsEntity);
                preparedRequest = this.jdbcPreparedStatementManager.setJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.UPDATE, sqlUpdateString);
            }
            ArrayList listPreparedEntities = new ArrayList();
            listPreparedEntities.addAll(ddbsEntity.getEntityNonIDProperties());
            listPreparedEntities.addAll(ddbsEntity.getEntityIDProperties());
            this.jdbcConditionConverter.prepareParametersPreparedStatement(preparedRequest, listPreparedEntities, objectToUpdate);
            return this.jdbcConnector.executePreparedQuery(preparedRequest) == 1;
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
    }

    protected String getDeleteSQLString(DDBSEntity<DDBSEntityProperty> ddbsEntity) {
        StringBuilder sqlDeleteString = new StringBuilder();
        sqlDeleteString.append("DELETE FROM ");
        sqlDeleteString.append(ddbsEntity.getDatastoreEntityName());
        sqlDeleteString.append(" WHERE ");
        Iterator iteratorIDProperties = ddbsEntity.getEntityIDProperties().iterator();
        while (iteratorIDProperties.hasNext()) {
            sqlDeleteString.append(((DDBSEntityProperty)iteratorIDProperties.next()).getPropertyName());
            sqlDeleteString.append(" = ?");
            if (!iteratorIDProperties.hasNext()) continue;
            sqlDeleteString.append(" AND ");
        }
        return sqlDeleteString.toString();
    }

    public boolean delete(IEntity objectToDelete) throws DDBSToolkitException {
        this.testConnection(objectToDelete);
        try {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(objectToDelete);
            PreparedStatement preparedRequest = this.jdbcPreparedStatementManager.getJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.DELETE);
            if (preparedRequest == null) {
                String sqlDeleteString = this.getDeleteSQLString((DDBSEntity<DDBSEntityProperty>)ddbsEntity);
                preparedRequest = this.jdbcPreparedStatementManager.setJDBCPreparedStatements((DDBSEntity<DDBSEntityProperty>)ddbsEntity, PreparedStatementType.DELETE, sqlDeleteString);
            }
            this.jdbcConditionConverter.prepareParametersPreparedStatement(preparedRequest, ddbsEntity.getEntityIDProperties(), objectToDelete);
            return this.jdbcConnector.executePreparedQuery(preparedRequest) == 1;
        }
        catch (SQLException sqle) {
            throw new DDBSToolkitException("Error during execution of the SQL request", (Throwable)sqle);
        }
    }

    public <T extends IEntity> T loadArray(T objectToLoad, String field, OrderBy orderBy) throws DDBSToolkitException {
        this.testConnection(objectToLoad);
        if (objectToLoad != null && field != null && !field.isEmpty()) {
            DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(objectToLoad);
            List idProperties = ddbsEntity.getEntityIDProperties();
            if (!idProperties.isEmpty()) {
                StringBuilder conditionQueryString = new StringBuilder();
                Iterator conditionIterator = idProperties.iterator();
                while (conditionIterator.hasNext()) {
                    DDBSEntityProperty idProperty = (DDBSEntityProperty)conditionIterator.next();
                    conditionQueryString.append(idProperty.getPropertyName());
                    conditionQueryString.append(" = ");
                    conditionQueryString.append(idProperty.getValue(objectToLoad));
                    if (!conditionIterator.hasNext()) continue;
                    conditionQueryString.append(" AND ");
                }
                DDBSEntityProperty propertyName = ddbsEntity.getDDBSEntityProperty(field);
                if (propertyName != null) {
                    try {
                        IEntity objectLinked = (IEntity)Class.forName(propertyName.getObjectTypeName()).newInstance();
                        List<IEntity> listObject = this.listAllWithQueryString(objectLinked, conditionQueryString.toString(), orderBy);
                        Object array = Array.newInstance(Class.forName(propertyName.getObjectTypeName()), listObject.size());
                        propertyName.setValue(objectToLoad, array);
                        int counterArray = 0;
                        for (IEntity entity : listObject) {
                            Array.set(array, counterArray, entity);
                            ++counterArray;
                        }
                        return objectToLoad;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new DDBSToolkitException("Class " + propertyName.getObjectTypeName() + " not found", (Throwable)e);
                    }
                    catch (SecurityException e) {
                        throw new DDBSToolkitException("No such field " + field, (Throwable)e);
                    }
                }
                throw new DDBSToolkitException("No property " + field + " found for object " + ddbsEntity.getDatastoreEntityName());
            }
            throw new DDBSToolkitException("There is no primary key defined for object " + ddbsEntity.getDatastoreEntityName());
        }
        throw new IllegalArgumentException();
    }

    public boolean createEntity(IEntity objectToCreate) throws DDBSToolkitException {
        throw new UnsupportedOperationException();
    }

    protected <T extends IEntity> List<T> conversionResultSet(ResultSet results, T myObject) throws DDBSToolkitException {
        ArrayList<IEntity> resultList = new ArrayList<IEntity>();
        DDBSEntity ddbsEntity = this.ddbsEntityManager.getDDBSEntity(myObject);
        List listProperties = ddbsEntity.getEntityProperties();
        try {
            while (results.next()) {
                IEntity myData = (IEntity)ddbsEntity.newInstance();
                for (DDBSEntityProperty myProperty : listProperties) {
                    if (myProperty.isArray()) continue;
                    if (myProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.INTEGER)) {
                        myProperty.setValue(myData, (Object)results.getInt(myProperty.getPropertyName()));
                    } else if (myProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.LONG)) {
                        myProperty.setValue(myData, (Object)results.getLong(myProperty.getPropertyName()));
                    } else if (myProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.FLOAT)) {
                        myProperty.setValue(myData, (Object)Float.valueOf(results.getFloat(myProperty.getPropertyName())));
                    } else if (myProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.DOUBLE)) {
                        myProperty.setValue(myData, (Object)results.getDouble(myProperty.getPropertyName()));
                    } else if (myProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.STRING)) {
                        myProperty.setValue(myData, (Object)results.getString(myProperty.getPropertyName()));
                    } else if (myProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.TIMESTAMP)) {
                        myProperty.setValue(myData, (Object)results.getTimestamp(myProperty.getPropertyName()));
                    }
                    if (!results.wasNull()) continue;
                    myProperty.setValue(myData, null);
                }
                resultList.add(myData);
            }
        }
        catch (SecurityException se) {
            throw new DDBSToolkitException("Security exception using reflection", (Throwable)se);
        }
        catch (IllegalArgumentException iae) {
            throw new DDBSToolkitException("Illegal argument exception using reflection", (Throwable)iae);
        }
        catch (SQLException se) {
            throw new DDBSToolkitException("SQL exception during parsing the request", (Throwable)se);
        }
        return resultList;
    }
}

