/*
 * Decompiled with CFR 0.152.
 */
package org.ddbstoolkit.toolkit.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class JDBCConnector {
    protected Connection connector;
    protected String jdbcString;
    protected long connectionId;

    protected JDBCConnector(String jdbcString) {
        this.jdbcString = jdbcString;
    }

    public JDBCConnector(Connection connector) {
        this.connector = connector;
    }

    public boolean isOpen() throws SQLException {
        return this.connector != null && !this.connector.isClosed();
    }

    public void open() throws SQLException {
        this.connector = DriverManager.getConnection(this.jdbcString);
    }

    public void close() throws SQLException {
        if (this.connector != null) {
            this.connector.close();
        }
    }

    public int executeQuery(String sql) throws SQLException {
        Statement stmt = this.connector.createStatement();
        return stmt.executeUpdate(sql);
    }

    public int executePreparedQuery(PreparedStatement preparedRequest) throws SQLException {
        return preparedRequest.executeUpdate();
    }

    public ResultSet query(String sql) throws SQLException {
        Statement stmt = this.connector.createStatement();
        return stmt.executeQuery(sql);
    }

    public ResultSet queryPreparedStatement(PreparedStatement preparedRequest) throws SQLException {
        return preparedRequest.executeQuery();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connector.prepareStatement(sql);
    }

    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        this.connector.setAutoCommit(isAutoCommit);
    }

    public boolean isAutoCommit() throws SQLException {
        return this.connector.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.connector.commit();
    }

    public void rollback() throws SQLException {
        this.connector.rollback();
    }
}

