/*
 * Decompiled with CFR 0.152.
 */
package org.ddbstoolkit.toolkit.jdbc;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.ddbstoolkit.toolkit.core.DDBSTransaction;
import org.ddbstoolkit.toolkit.jdbc.JDBCConnector;

public abstract class JDBCConnectionPool {
    protected BoneCP connectionPool;
    protected int numberOfConnection;
    protected Map<String, Connection> connectionSession;
    protected String jdbcString;

    public JDBCConnectionPool(String jdbcString, int numberOfConnection) throws SQLException {
        this.numberOfConnection = numberOfConnection;
        this.jdbcString = jdbcString;
        BoneCPConfig config = new BoneCPConfig();
        config.setJdbcUrl(jdbcString);
        this.connectionPool = new BoneCP(config);
        this.connectionSession = new HashMap<String, Connection>();
    }

    public DDBSTransaction createSession() throws SQLException {
        long mapKey;
        Random random = new Random();
        while (this.connectionSession.get(String.valueOf(mapKey = random.nextLong())) != null) {
        }
        Connection connection = this.connectionPool.getConnection();
        this.connectionSession.put(String.valueOf(mapKey), connection);
        return new DDBSTransaction(String.valueOf(mapKey));
    }

    public Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection();
    }

    public Connection getConnection(DDBSTransaction transaction) {
        return this.connectionSession.get(transaction.getTransactionId());
    }

    public void endSession(DDBSTransaction transaction) throws SQLException {
        this.connectionSession.get(transaction.getTransactionId()).close();
        this.connectionSession.remove(transaction.getTransactionId());
    }

    public void shutdownConnectionPool() {
        this.connectionPool.shutdown();
    }

    public abstract JDBCConnector getJDBCConnector(Connection var1) throws SQLException;

    public String toString() {
        return "JDBCConnectionPool [numberOfConnection=" + this.numberOfConnection + "]";
    }
}

