/*
 * Decompiled with CFR 0.152.
 */
package org.ddbstoolkit.toolkit.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import org.ddbstoolkit.toolkit.core.IEntity;
import org.ddbstoolkit.toolkit.core.conditions.Condition;
import org.ddbstoolkit.toolkit.core.conditions.ConditionBetweenValue;
import org.ddbstoolkit.toolkit.core.conditions.ConditionInValues;
import org.ddbstoolkit.toolkit.core.conditions.ConditionSingleValue;
import org.ddbstoolkit.toolkit.core.conditions.Conditions;
import org.ddbstoolkit.toolkit.core.conditions.ConditionsConverter;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntity;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntityManager;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSEntityProperty;
import org.ddbstoolkit.toolkit.core.reflexion.DDBSToolkitSupportedEntity;

public class JDBCConditionConverter
implements ConditionsConverter {
    private final DDBSEntityManager<DDBSEntity<DDBSEntityProperty>> entityManager;

    public JDBCConditionConverter(DDBSEntityManager<DDBSEntity<DDBSEntityProperty>> entityManager) {
        this.entityManager = entityManager;
    }

    public String getConditionsString(Conditions conditions, IEntity object) {
        StringBuilder conditionString = new StringBuilder();
        Iterator iteratorConditions = conditions.getConditions().iterator();
        DDBSEntity entity = this.entityManager.getDDBSEntity(object);
        while (iteratorConditions.hasNext()) {
            Condition condition = (Condition)iteratorConditions.next();
            String propertyName = entity.getDDBSEntityProperty(condition.getName()).getPropertyName();
            conditionString.append(propertyName);
            switch (condition.getConditionType()) {
                case EQUAL: {
                    conditionString.append(" = ?");
                    break;
                }
                case NOT_EQUAL: {
                    conditionString.append(" <> ?");
                    break;
                }
                case LESS_THAN: {
                    conditionString.append(" < ?");
                    break;
                }
                case GREATER_THAN: {
                    conditionString.append(" > ?");
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    conditionString.append(" <= ?");
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    conditionString.append(" >= ?");
                    break;
                }
                case BETWEEN: {
                    conditionString.append(" BETWEEN ? AND ?");
                    break;
                }
                case NOT_BETWEEN: {
                    conditionString.append(" NOT BETWEEN ? AND ?");
                    break;
                }
                case LIKE: {
                    conditionString.append(" LIKE ?");
                    break;
                }
                case IN: {
                    conditionString.append(" IN (");
                    Iterator iteratorIn = ((ConditionInValues)condition).getValues().iterator();
                    while (iteratorIn.hasNext()) {
                        iteratorIn.next();
                        conditionString.append(" ? ");
                        if (!iteratorIn.hasNext()) continue;
                        conditionString.append(",");
                    }
                    conditionString.append(")");
                    break;
                }
                case NOT_IN: {
                    conditionString.append(" NOT IN (");
                    Iterator iteratorNotIn = ((ConditionInValues)condition).getValues().iterator();
                    while (iteratorNotIn.hasNext()) {
                        iteratorNotIn.next();
                        conditionString.append(" ? ");
                        if (!iteratorNotIn.hasNext()) continue;
                        conditionString.append(",");
                    }
                    conditionString.append(")");
                    break;
                }
                case IS_NULL: {
                    conditionString.append(" IS NULL");
                    break;
                }
                case IS_NOT_NULL: {
                    conditionString.append(" IS NOT NULL");
                    break;
                }
            }
            if (!iteratorConditions.hasNext()) continue;
            conditionString.append(" AND ");
        }
        return conditionString.toString();
    }

    public void prepareStatement(PreparedStatement preparedStatement, Conditions conditions, DDBSEntity<DDBSEntityProperty> ddbsEntity) throws SQLException {
        int counterParameter = 1;
        for (Condition condition : conditions.getConditions()) {
            DDBSEntityProperty ddbsEntityProperty = ddbsEntity.getDDBSEntityProperty(condition.getName());
            if (condition instanceof ConditionSingleValue) {
                this.prepareData(preparedStatement, counterParameter, ddbsEntityProperty, ((ConditionSingleValue)condition).getValue());
                ++counterParameter;
                continue;
            }
            if (condition instanceof ConditionBetweenValue) {
                this.prepareData(preparedStatement, counterParameter, ddbsEntityProperty, ((ConditionBetweenValue)condition).getStartingValue());
                this.prepareData(preparedStatement, ++counterParameter, ddbsEntityProperty, ((ConditionBetweenValue)condition).getEndingValue());
                ++counterParameter;
                continue;
            }
            if (!(condition instanceof ConditionInValues)) continue;
            for (Object object : ((ConditionInValues)condition).getValues()) {
                this.prepareData(preparedStatement, counterParameter, ddbsEntityProperty, object);
                ++counterParameter;
            }
        }
    }

    public <T extends DDBSEntityProperty> PreparedStatement prepareParametersPreparedStatement(PreparedStatement preparedStatement, List<T> ddbsEntityProperties, IEntity entity) throws SQLException {
        int counterParameter = 1;
        for (DDBSEntityProperty ddbsEntityProperty : ddbsEntityProperties) {
            this.prepareData(preparedStatement, counterParameter, ddbsEntityProperty, ddbsEntityProperty.getValue(entity));
            ++counterParameter;
        }
        return preparedStatement;
    }

    private void prepareData(PreparedStatement preparedStatement, int counterParameter, DDBSEntityProperty ddbsEntityProperty, Object value) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(counterParameter, 0);
        } else if (ddbsEntityProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.INTEGER)) {
            preparedStatement.setInt(counterParameter, (Integer)value);
        } else if (ddbsEntityProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.LONG)) {
            preparedStatement.setLong(counterParameter, (Long)value);
        } else if (ddbsEntityProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.FLOAT)) {
            preparedStatement.setFloat(counterParameter, ((Float)value).floatValue());
        } else if (ddbsEntityProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.DOUBLE)) {
            preparedStatement.setDouble(counterParameter, (Double)value);
        } else if (ddbsEntityProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.STRING)) {
            preparedStatement.setString(counterParameter, (String)value);
        } else if (ddbsEntityProperty.getDdbsToolkitSupportedEntity().equals(DDBSToolkitSupportedEntity.TIMESTAMP)) {
            preparedStatement.setTimestamp(counterParameter, (Timestamp)value);
        }
    }
}

